/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.bean.permute.assign;

import java.lang.reflect.Field;
import java.util.List;
import org.anchoranalysis.bean.AnchorBean;
import org.anchoranalysis.bean.permute.assign.AssignPermutationException;
import org.anchoranalysis.bean.permute.assign.FindBean;
import org.anchoranalysis.bean.permute.assign.ListAssigner;
import org.anchoranalysis.bean.permute.assign.PermutationAssigner;
import org.anchoranalysis.bean.permute.assign.SingleAssigner;

public class PermutationAssignerFactory {
    public static PermutationAssigner createForSingle(AnchorBean<?> bean, String propertyPath) throws AssignPermutationException {
        String[] tokens = propertyPath.split("\\.");
        if (tokens.length == 1) {
            Field finalField = PermutationAssignerFactory.findMatchingField(bean.fields(), propertyPath);
            return new SingleAssigner(finalField);
        }
        return PermutationAssignerFactory.createWithIntermediateProperties(bean, tokens);
    }

    public static PermutationAssigner combine(List<PermutationAssigner> assigners) {
        return new ListAssigner(assigners);
    }

    private static Field findMatchingField(List<Field> list, String propertyName) throws AssignPermutationException {
        for (Field f : list) {
            if (!f.getName().equals(propertyName)) continue;
            return f;
        }
        throw new AssignPermutationException(String.format("Cannot find matching field for property '%s'", propertyName));
    }

    private static PermutationAssigner createWithIntermediateProperties(AnchorBean<?> parentBean, String[] tokens) throws AssignPermutationException {
        SingleAssigner setter = new SingleAssigner();
        AnchorBean<?> currentBean = parentBean;
        List<Field> currentList = currentBean.fields();
        int intermediateFields = tokens.length - 1;
        for (int i = 0; i < intermediateFields; ++i) {
            String currentPropertyName = tokens[i];
            Field matchedField = PermutationAssignerFactory.findMatchingField(currentList, currentPropertyName);
            setter.addField(matchedField);
            currentBean = FindBean.beanFor(matchedField, currentBean);
            currentList = currentBean.fields();
        }
        setter.addField(PermutationAssignerFactory.findMatchingField(currentList, tokens[intermediateFields]));
        return setter;
    }

    private PermutationAssignerFactory() {
    }
}

