/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.bean.xml;

import java.nio.file.Path;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.anchoranalysis.bean.exception.BeanStrangeException;
import org.anchoranalysis.bean.xml.AssociateXMLUponLoad;
import org.anchoranalysis.bean.xml.HelperReadXML;
import org.anchoranalysis.bean.xml.RegisterBeanFactories;
import org.anchoranalysis.bean.xml.exception.BeanXMLException;
import org.anchoranalysis.bean.xml.exception.FriendlyExceptionCreator;
import org.anchoranalysis.bean.xml.exception.LocalisedBeanException;
import org.anchoranalysis.core.exception.combinable.AnchorCombinableException;
import org.apache.commons.configuration.ConfigurationRuntimeException;
import org.apache.commons.configuration.HierarchicalConfiguration;
import org.apache.commons.configuration.XMLConfiguration;
import org.apache.commons.configuration.beanutils.BeanDeclaration;
import org.apache.commons.configuration.beanutils.BeanHelper;
import org.apache.commons.configuration.beanutils.XMLBeanDeclaration;

public class BeanXMLLoader {
    private static Logger logger = Logger.getLogger(BeanXMLLoader.class.getName());

    public static <T> T loadBean(Path path) throws BeanXMLException {
        return BeanXMLLoader.loadBean(path, "bean");
    }

    public static <T> T loadBean(Path path, String xmlPath) throws BeanXMLException {
        try {
            return BeanXMLLoader.loadBeanLocalized(path, xmlPath);
        }
        catch (LocalisedBeanException e) {
            throw e.summarizeIgnoreIdenticalFilePath(path);
        }
    }

    public static <T> T loadBeanLocalized(Path path, String xmlPath) throws BeanXMLException, LocalisedBeanException {
        XMLConfiguration includeXML;
        BeanXMLLoader.checkBeansRegistered();
        try {
            includeXML = HelperReadXML.readBeanXMLFromFilesystem(path);
        }
        catch (BeanXMLException e) {
            throw new LocalisedBeanException(path.toString(), (Throwable)((Object)e));
        }
        try {
            return BeanXMLLoader.createFromXMLConfigurationLocalised((HierarchicalConfiguration)includeXML, xmlPath, path);
        }
        catch (IllegalArgumentException e) {
            throw BeanXMLLoader.convertIllegalArgumentException(e, xmlPath);
        }
    }

    public static <T extends AssociateXMLUponLoad> T loadBeanAssociatedXml(Path path, String xmlPath) throws BeanXMLException {
        try {
            return BeanXMLLoader.loadBeanAssociatedXmlLocalized(path, xmlPath);
        }
        catch (LocalisedBeanException e) {
            throw e.summarizeIgnoreIdenticalFilePath(path);
        }
    }

    private static <T extends AssociateXMLUponLoad> T loadBeanAssociatedXmlLocalized(Path path, String xmlPath) throws BeanXMLException, LocalisedBeanException {
        BeanXMLLoader.checkBeansRegistered();
        try {
            XMLConfiguration configXML = HelperReadXML.readBeanXMLFromFilesystem(path);
            AssociateXMLUponLoad loadedBean = (AssociateXMLUponLoad)BeanXMLLoader.createFromXMLConfigurationLocalised((HierarchicalConfiguration)configXML, xmlPath, path);
            loadedBean.associateXML(configXML);
            return (T)loadedBean;
        }
        catch (IllegalArgumentException e) {
            throw BeanXMLLoader.convertIllegalArgumentException(e, xmlPath);
        }
    }

    private static BeanXMLException convertIllegalArgumentException(IllegalArgumentException e, String xmlPath) {
        if (e.getMessage().contains("Passed in key must select exactly one node")) {
            return new BeanXMLException(String.format("An expected XML node could not be found: <%s/> or <%s></%s>", xmlPath, xmlPath, xmlPath));
        }
        return new BeanXMLException(e);
    }

    private static <T> T createFromXMLConfigurationLocalised(HierarchicalConfiguration config, String xmlPath, Path currentFilePath) throws LocalisedBeanException {
        Path currentFilePathAbsolute = currentFilePath.toAbsolutePath();
        try {
            assert (currentFilePathAbsolute.isAbsolute());
            return BeanXMLLoader.createFromXMLConfiguration(config, xmlPath, currentFilePathAbsolute);
        }
        catch (ConfigurationRuntimeException e) {
            Throwable cause = FriendlyExceptionCreator.maybeCreateUserFriendlyException(e.getCause());
            if (cause instanceof AnchorCombinableException) {
                AnchorCombinableException causeCast = (AnchorCombinableException)cause;
                cause = causeCast.summarize();
            }
            logger.log(Level.FINE, "XML Configuration error when loading BeanXML", e);
            throw new LocalisedBeanException(currentFilePathAbsolute.toString(), cause);
        }
        catch (IllegalArgumentException e) {
            throw new LocalisedBeanException(currentFilePathAbsolute.toString(), (Throwable)((Object)BeanXMLLoader.convertIllegalArgumentException(e, xmlPath)));
        }
        catch (Exception e) {
            throw new LocalisedBeanException(currentFilePathAbsolute.toString(), e);
        }
    }

    private static <T> T createFromXMLConfiguration(HierarchicalConfiguration config, String xmlPath, Path currentFilePath) {
        assert (currentFilePath.isAbsolute());
        return (T)BeanHelper.createBean((BeanDeclaration)new XMLBeanDeclaration(config, xmlPath), null, (Object)currentFilePath.toString());
    }

    private static void checkBeansRegistered() {
        if (!RegisterBeanFactories.isCalledRegisterAllPackage()) {
            throw new BeanStrangeException(String.format("Please call %s.registerAllPackageBeanFactories() before loading any beans", RegisterBeanFactories.class.getSimpleName()));
        }
    }

    private BeanXMLLoader() {
    }
}

