/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.bean.xml.factory;

import java.nio.file.Path;
import java.nio.file.Paths;
import org.anchoranalysis.bean.AnchorBean;
import org.anchoranalysis.bean.BeanInstanceMap;
import org.anchoranalysis.bean.xml.exception.BeanMisconfiguredXMLException;
import org.anchoranalysis.bean.xml.exception.BeanXMLException;
import org.anchoranalysis.bean.xml.exception.FriendlyExceptionCreator;
import org.anchoranalysis.bean.xml.factory.DefaultBeanFactoryHelperInit;
import org.anchoranalysis.bean.xml.factory.HelperDescribeXmlNode;
import org.apache.commons.configuration.ConfigurationRuntimeException;
import org.apache.commons.configuration.beanutils.BeanDeclaration;
import org.apache.commons.configuration.beanutils.BeanFactory;
import org.apache.commons.configuration.beanutils.XMLBeanDeclaration;

public class AnchorDefaultBeanFactory
implements BeanFactory {
    private BeanInstanceMap defaultInstances;

    public Object createBean(Class<?> beanClass, BeanDeclaration data, Object parameter) throws Exception {
        try {
            Object result = this.createBeanInstance(beanClass, data);
            this.initBeanInstance(result, data, parameter);
            if (result instanceof AnchorBean) {
                AnchorBean resultCast = (AnchorBean)result;
                resultCast.checkMisconfigured(this.defaultInstances);
                Path localPath = Paths.get((String)parameter, new String[0]);
                resultCast.localise(localPath);
            }
            return result;
        }
        catch (ConfigurationRuntimeException e) {
            if (data instanceof XMLBeanDeclaration) {
                throw AnchorDefaultBeanFactory.createMisconfiguredBeanException(e, (XMLBeanDeclaration)data);
            }
            String msg = String.format("A misconfigured bean (%s) exists at unknown location", beanClass.getName());
            throw new BeanXMLException(msg, e.getCause());
        }
    }

    private static BeanMisconfiguredXMLException createMisconfiguredBeanException(ConfigurationRuntimeException exception, XMLBeanDeclaration dataCast) {
        String msg = String.format("A misconfigured bean exists%n%s", HelperDescribeXmlNode.describeXMLNode(dataCast.getNode()));
        return new BeanMisconfiguredXMLException(msg, AnchorDefaultBeanFactory.maybeRepaceException(exception));
    }

    private static Throwable maybeRepaceException(ConfigurationRuntimeException exc) {
        if (AnchorDefaultBeanFactory.isListMissingFactory(exc.getCause())) {
            return new BeanXMLException("A list declaration in BeanXML is missing its factory. Please add config-factory=\"list\"");
        }
        return FriendlyExceptionCreator.maybeCreateUserFriendlyException(exc);
    }

    public Class<?> getDefaultBeanClass() {
        return null;
    }

    private Object createBeanInstance(Class<?> beanClass, BeanDeclaration data) throws Exception {
        return beanClass.getConstructor(new Class[0]).newInstance(new Object[0]);
    }

    private void initBeanInstance(Object bean, BeanDeclaration data, Object parameter) throws Exception {
        DefaultBeanFactoryHelperInit.initBean(bean, data, parameter);
    }

    private static boolean isListMissingFactory(Throwable exc) {
        return exc instanceof NoSuchMethodException && exc.getMessage().equals("java.util.List.<init>()");
    }

    public AnchorDefaultBeanFactory(BeanInstanceMap defaultInstances) {
        this.defaultInstances = defaultInstances;
    }

    public BeanInstanceMap getDefaultInstances() {
        return this.defaultInstances;
    }
}

