/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.bean.xml.factory;

import java.lang.reflect.InvocationTargetException;
import org.anchoranalysis.bean.AnchorBean;
import org.anchoranalysis.bean.BeanInstanceMap;
import org.anchoranalysis.bean.xml.creator.BeanCreator;
import org.anchoranalysis.bean.xml.exception.BeanXMLException;
import org.anchoranalysis.bean.xml.factory.AnchorBeanFactory;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.configuration.beanutils.BeanDeclaration;
import org.apache.commons.configuration.beanutils.XMLBeanDeclaration;

public class ReplacePropertyBeanFactory<T extends AnchorBean<T>>
extends AnchorBeanFactory {
    private static final String ITEM = "item";
    private static final String REPLACEMENT = "replacement";
    private static final String KEY = "key";
    private final BeanInstanceMap defaultInstances;

    public synchronized Object createBean(Class beanClass, BeanDeclaration decl, Object param) throws Exception {
        XMLBeanDeclaration declXML = (XMLBeanDeclaration)decl;
        this.checkElement(declXML, ITEM);
        this.checkAttribute(declXML, KEY);
        boolean attribute = this.isReplaceAttribute(declXML);
        String key = (String)declXML.getBeanProperties().get(KEY);
        T bean = this.extractBeanAndReplace(declXML, key, attribute, param);
        ((AnchorBean)bean).checkMisconfigured(this.defaultInstances);
        return bean;
    }

    private T extractBeanAndReplace(XMLBeanDeclaration declXML, String key, boolean attribute, Object param) throws BeanXMLException {
        AnchorBean bean = (AnchorBean)BeanCreator.createBeanFromXML(declXML, ITEM, param);
        Object replacement = this.extractReplacement(declXML, attribute, param);
        if (!ReplacePropertyBeanFactory.hasProperty(bean, key)) {
            throw new BeanXMLException(String.format("There is no property '%s' on the item on which the replacement occurs", key));
        }
        try {
            BeanUtils.setProperty((Object)bean, (String)key, (Object)replacement);
        }
        catch (IllegalAccessException | InvocationTargetException exc) {
            throw new BeanXMLException(String.format("Cannot set property '%s'", key), exc);
        }
        return (T)bean;
    }

    private static <S extends AnchorBean<S>> boolean hasProperty(S bean, String property) {
        try {
            BeanUtils.getProperty(bean, (String)property);
            return true;
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            return false;
        }
    }

    private Object extractReplacement(XMLBeanDeclaration declXML, boolean attribute, Object param) {
        if (attribute) {
            return declXML.getBeanProperties().get(REPLACEMENT);
        }
        return BeanCreator.createBeanFromXML(declXML, REPLACEMENT, param);
    }

    private boolean isReplaceAttribute(XMLBeanDeclaration declXML) throws BeanXMLException {
        boolean element = this.hasElement(declXML, REPLACEMENT);
        boolean attribute = this.hasAttribute(declXML, REPLACEMENT);
        if (element && attribute) {
            throw new BeanXMLException("The 'replacement' property is set on the bean as both an attribute and element. Only one is allowed.");
        }
        if (!element && !attribute) {
            throw new BeanXMLException("The 'replacement' property is NOT set on the bean");
        }
        return attribute;
    }

    private void checkAttribute(XMLBeanDeclaration declXML, String key) throws BeanXMLException {
        if (!this.hasAttribute(declXML, key)) {
            throw new BeanXMLException(String.format("This bean must have a '%s' attribute set", key));
        }
    }

    private void checkElement(XMLBeanDeclaration declXML, String key) throws BeanXMLException {
        if (!this.hasElement(declXML, key)) {
            throw new BeanXMLException(String.format("This bean must have a '%s' element set", key));
        }
    }

    private boolean hasAttribute(XMLBeanDeclaration declXML, String key) {
        return declXML.getBeanProperties().containsKey(key);
    }

    private boolean hasElement(XMLBeanDeclaration declXML, String key) {
        return declXML.getNestedBeanDeclarations().containsKey(key);
    }

    public ReplacePropertyBeanFactory(BeanInstanceMap defaultInstances) {
        this.defaultInstances = defaultInstances;
    }
}

