/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.bean.xml.factory.primitive;

import java.util.function.Function;
import org.anchoranalysis.bean.primitive.PrimitiveBeanCollection;
import org.anchoranalysis.bean.xml.exception.BeanXMLException;
import org.apache.commons.configuration.beanutils.BeanDeclaration;
import org.apache.commons.configuration.beanutils.XMLBeanDeclaration;
import org.apache.commons.configuration.tree.ConfigurationNode;

class PopulatePrimitives<T> {
    private XMLBeanDeclaration declaration;
    private PrimitiveBeanCollection<T> collectionToPopulate;
    private Function<String, T> convertToPrimitive;

    public PopulatePrimitives(BeanDeclaration declaration, PrimitiveBeanCollection<T> collectionToPopulate, Function<String, T> convertToPrimitive) {
        this.declaration = (XMLBeanDeclaration)declaration;
        this.collectionToPopulate = collectionToPopulate;
        this.convertToPrimitive = convertToPrimitive;
    }

    public PrimitiveBeanCollection<T> populate() throws BeanXMLException {
        this.populateFromElements();
        return this.populateFromAttribute();
    }

    private PrimitiveBeanCollection<T> populateFromElements() throws BeanXMLException {
        return this.populateFromExtractedStrings(decl -> decl.getConfiguration().getStringArray("item"));
    }

    private PrimitiveBeanCollection<T> populateFromAttribute() throws BeanXMLException {
        return this.populateFromExtractedStrings(xmlDeclaration -> PopulatePrimitives.separatedValuesFromAttribute(xmlDeclaration, "items"));
    }

    private PrimitiveBeanCollection<T> populateFromExtractedStrings(Function<XMLBeanDeclaration, String[]> extractItems) throws BeanXMLException {
        String[] items;
        for (String item : items = extractItems.apply(this.declaration)) {
            try {
                T converted = this.convertToPrimitive.apply(item);
                this.collectionToPopulate.add(converted);
            }
            catch (Exception e) {
                throw new BeanXMLException("The BeanXML contains invalid content for the desired primitives.", e);
            }
        }
        return this.collectionToPopulate;
    }

    private static String[] separatedValuesFromAttribute(XMLBeanDeclaration declaration, String attributeName) {
        return (String[])declaration.getNode().getAttributes().stream().filter(node -> node.getName().contentEquals(attributeName)).map(ConfigurationNode::getValue).toArray(String[]::new);
    }

    private PopulatePrimitives() {
    }
}

