/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.bean;

import java.lang.reflect.Field;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import lombok.Generated;
import org.anchoranalysis.bean.AnchorBean;
import org.anchoranalysis.bean.FieldAccessor;
import org.anchoranalysis.bean.exception.BeanMisconfiguredException;
import org.anchoranalysis.bean.exception.BeanStrangeException;

class HelperFindChildren {
    public static <T extends AnchorBean<?>> List<T> findChildrenOfClass(AnchorBean<?> bean, List<Field> listFields, Class<?> match) throws BeanMisconfiguredException {
        LinkedList out = new LinkedList();
        try {
            for (Field field : listFields) {
                FieldAccessor.fieldFromBean(bean, field).ifPresent(value -> HelperFindChildren.maybeAdd(value, match, out));
            }
        }
        catch (IllegalAccessException e) {
            throw new BeanStrangeException("While using reflection, a permissions problem occurred", e);
        }
        return out;
    }

    private static <T extends AnchorBean<?>> void maybeAdd(Object fieldValue, Class<?> match, List<T> out) {
        Object valueCast;
        if (fieldValue instanceof AnchorBean && match.isAssignableFrom((valueCast = (AnchorBean)fieldValue).getClass())) {
            out.add(valueCast);
        }
        if (fieldValue instanceof Collection) {
            valueCast = (Collection)fieldValue;
            HelperFindChildren.maybeAddCollection(valueCast, match, out);
        }
    }

    private static <T extends AnchorBean<?>> void maybeAddCollection(Collection<AnchorBean<?>> list, Class<?> match, List<T> out) {
        for (AnchorBean<?> item : list) {
            if (item == null || !match.isAssignableFrom(item.getClass())) continue;
            out.add(item);
        }
    }

    @Generated
    private HelperFindChildren() {
    }
}

