/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.bean.define.adder;

import java.nio.file.Path;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.anchoranalysis.bean.AnchorBean;
import org.anchoranalysis.bean.NamedBean;
import org.anchoranalysis.bean.annotation.BeanField;
import org.anchoranalysis.bean.define.Define;
import org.anchoranalysis.bean.define.DefineAddException;
import org.anchoranalysis.bean.define.adder.DefineAdderBean;
import org.anchoranalysis.bean.xml.BeanXMLLoader;
import org.anchoranalysis.bean.xml.exception.BeanXMLException;
import org.anchoranalysis.bean.xml.exception.LocalisedBeanException;
import org.anchoranalysis.bean.xml.factory.BeanPathCalculator;
import org.anchoranalysis.core.format.NonImageFileFormat;

public class FromXMLList
extends DefineAdderBean {
    @BeanField
    private String name;
    @BeanField
    private boolean prefix = false;

    @Override
    public void addTo(Define define) throws DefineAddException {
        Optional<Path> path = this.resolvedPath();
        if (!path.isPresent()) {
            throw new DefineAddException("No path is associated with this bean");
        }
        try {
            List<NamedBean<AnchorBean<?>>> beans = this.loadList(path.get());
            if (this.prefix) {
                FromXMLList.addPrefix(beans, this.name + ".");
            }
            define.addAll(beans);
        }
        catch (BeanXMLException e) {
            throw new DefineAddException((Throwable)((Object)new LocalisedBeanException(path.get().toString(), (Throwable)((Object)e))));
        }
    }

    private static void addPrefix(List<NamedBean<AnchorBean<?>>> beans, String prefix) {
        for (NamedBean<AnchorBean<?>> bean : beans) {
            bean.setName(prefix + bean.getName());
        }
    }

    private Optional<Path> resolvedPath() {
        return BeanPathCalculator.pathFromBean(this, this.nameWithExtension());
    }

    private List<NamedBean<AnchorBean<?>>> loadList(Path path) throws BeanXMLException {
        return (List)BeanXMLLoader.loadBean(path);
    }

    private String nameWithExtension() {
        return NonImageFileFormat.XML.buildPath(this.name);
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public boolean isPrefix() {
        return this.prefix;
    }

    @Generated
    public void setPrefix(boolean prefix) {
        this.prefix = prefix;
    }
}

