/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.bean.initializable;

import java.util.LinkedList;
import java.util.List;
import java.util.stream.Stream;
import lombok.Generated;
import org.anchoranalysis.bean.AnchorBean;

final class BeanAndParent {
    private final AnchorBean<?> bean;
    private final BeanAndParent parent;

    public AnchorBean<?> parentBean() {
        return this.parent != null ? this.parent.getBean() : null;
    }

    public String pathFromRootAsString() {
        return BeanAndParent.stringFromPath(this.beansRootToLeaf());
    }

    private List<AnchorBean<?>> beansRootToLeaf() {
        LinkedList listObjects = new LinkedList();
        BeanAndParent next = this;
        listObjects.add(0, next.getBean());
        while ((next = next.getParent()) != null) {
            listObjects.add(0, next.getBean());
        }
        return listObjects;
    }

    private static String stringFromPath(List<AnchorBean<?>> listObjects) {
        Stream<String> names = listObjects.stream().map(AnchorBean::getBeanName);
        return String.join((CharSequence)"->", (Iterable)((Object)names));
    }

    @Generated
    public AnchorBean<?> getBean() {
        return this.bean;
    }

    @Generated
    public BeanAndParent getParent() {
        return this.parent;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BeanAndParent)) {
            return false;
        }
        BeanAndParent other = (BeanAndParent)o;
        AnchorBean<?> this$bean = this.getBean();
        AnchorBean<?> other$bean = other.getBean();
        if (this$bean == null ? other$bean != null : !this$bean.equals(other$bean)) {
            return false;
        }
        BeanAndParent this$parent = this.getParent();
        BeanAndParent other$parent = other.getParent();
        return !(this$parent == null ? other$parent != null : !((Object)this$parent).equals(other$parent));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        AnchorBean<?> $bean = this.getBean();
        result = result * 59 + ($bean == null ? 43 : $bean.hashCode());
        BeanAndParent $parent = this.getParent();
        result = result * 59 + ($parent == null ? 43 : ((Object)$parent).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "BeanAndParent(bean=" + String.valueOf(this.getBean()) + ", parent=" + String.valueOf(this.getParent()) + ")";
    }

    @Generated
    public BeanAndParent(AnchorBean<?> bean, BeanAndParent parent) {
        this.bean = bean;
        this.parent = parent;
    }
}

