/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.bean.initializable;

import java.lang.reflect.Field;
import java.util.Collection;
import java.util.List;
import lombok.Generated;
import org.anchoranalysis.bean.AnchorBean;
import org.anchoranalysis.bean.FieldAccessor;
import org.anchoranalysis.bean.annotation.SkipInit;
import org.anchoranalysis.bean.initializable.BeanAndParent;
import org.anchoranalysis.core.exception.InitializeException;

class FindChildrenForInit {
    public static void addChildrenFromBean(BeanAndParent bean, List<BeanAndParent> toAddTo) throws InitializeException {
        List<Field> beanFields = bean.getBean().fields();
        for (Field field : beanFields) {
            if (field.isAnnotationPresent(SkipInit.class)) continue;
            FindChildrenForInit.addChildrenMany(toAddTo, bean, field, FieldAccessor.isFieldAnnotatedAsOptional(field));
        }
    }

    private static void addChildrenMany(List<BeanAndParent> listOut, BeanAndParent bean, Field field, boolean optional) throws InitializeException {
        try {
            Object propertyValue = field.get(bean.getBean());
            if (propertyValue instanceof Collection) {
                Collection collection = (Collection)propertyValue;
                for (Object object : collection) {
                    FindChildrenForInit.addChildren(listOut, bean, object, false);
                }
                return;
            }
            FindChildrenForInit.addChildren(listOut, bean, propertyValue, optional);
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            throw new InitializeException((Throwable)e);
        }
    }

    private static void addChildren(List<BeanAndParent> listOut, BeanAndParent bean, Object propertyValue, boolean optional) {
        if (optional && propertyValue == null) {
            return;
        }
        if (propertyValue instanceof AnchorBean) {
            listOut.add(new BeanAndParent((AnchorBean)propertyValue, bean));
        }
    }

    @Generated
    private FindChildrenForInit() {
    }
}

