/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.bean.xml.factory;

import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.anchoranalysis.bean.xml.exception.BeanXMLException;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.configuration.ConfigurationRuntimeException;
import org.apache.commons.configuration.beanutils.BeanDeclaration;
import org.apache.commons.configuration.beanutils.BeanHelper;

class DefaultBeanFactoryHelperInit {
    public static void initBean(Object bean, BeanDeclaration data, Object parameter) throws BeanXMLException {
        BeanHelper.initBeanProperties((Object)bean, (BeanDeclaration)data);
        Map nestedBeans = data.getNestedBeanDeclarations();
        if (nestedBeans != null) {
            new InitNested(nestedBeans, parameter).initBean(bean);
        }
    }

    private static Optional<Class<?>> getDefaultClass(Object bean, String propName) {
        try {
            PropertyDescriptor desc = PropertyUtils.getPropertyDescriptor((Object)bean, (String)propName);
            if (desc == null) {
                return Optional.empty();
            }
            return Optional.of(desc.getPropertyType());
        }
        catch (Exception ex) {
            return Optional.empty();
        }
    }

    @Generated
    private DefaultBeanFactoryHelperInit() {
    }

    private static class InitNested {
        private final Map<String, Object> nestedBeans;
        private final Object parameter;

        public void initBean(Object bean) throws BeanXMLException {
            if (bean instanceof Collection) {
                this.initCollection((Collection)bean);
            } else {
                this.initNonCollection(bean);
            }
        }

        private void initCollection(Collection<Object> beanCollection) {
            if (this.nestedBeans.size() != 1) {
                return;
            }
            Map.Entry<String, Object> e = this.nestedBeans.entrySet().iterator().next();
            new InitCollection(beanCollection, e.getKey()).initialize(e.getValue(), this.parameter);
        }

        private void initNonCollection(Object bean) throws BeanXMLException {
            for (Map.Entry<String, Object> e : this.nestedBeans.entrySet()) {
                String propName = e.getKey();
                Optional<Class<?>> defaultClass = DefaultBeanFactoryHelperInit.getDefaultClass(bean, propName);
                Object object = e.getValue();
                if (object instanceof BeanDeclaration) {
                    BeanDeclaration value = (BeanDeclaration)object;
                    this.initProperty(bean, propName, BeanHelper.createBean((BeanDeclaration)value, (Class)defaultClass.orElse(null), (Object)this.parameter));
                    continue;
                }
                throw new BeanXMLException("The value of a Bean-Property field is neither a scalar primitive nor a bean.");
            }
        }

        private void initProperty(Object bean, String propName, Object value) {
            if (!PropertyUtils.isWriteable((Object)bean, (String)propName)) {
                throw new ConfigurationRuntimeException("Property " + propName + " cannot be set on " + bean.getClass().getName());
            }
            try {
                BeanUtils.setProperty((Object)bean, (String)propName, (Object)value);
            }
            catch (IllegalAccessException | InvocationTargetException iaex) {
                throw new ConfigurationRuntimeException((Throwable)iaex);
            }
        }

        @Generated
        public InitNested(Map<String, Object> nestedBeans, Object parameter) {
            this.nestedBeans = nestedBeans;
            this.parameter = parameter;
        }
    }

    private static class InitCollection {
        private final Collection<Object> beanCollection;
        private final Optional<Class<?>> defaultClass;

        public InitCollection(Collection<Object> beanCollection, String propName) {
            this.beanCollection = beanCollection;
            this.defaultClass = DefaultBeanFactoryHelperInit.getDefaultClass(beanCollection, propName);
        }

        public void initialize(Object propVal, Object parameter) {
            if (propVal instanceof List) {
                for (BeanDeclaration decl : (List)propVal) {
                    this.addWithParam(decl, parameter);
                }
            } else {
                this.addWithoutParam((BeanDeclaration)propVal);
            }
        }

        private void addWithoutParam(BeanDeclaration decl) {
            this.beanCollection.add(BeanHelper.createBean((BeanDeclaration)decl, (Class)this.defaultClass.orElse(null)));
        }

        private void addWithParam(BeanDeclaration decl, Object parameter) {
            this.beanCollection.add(BeanHelper.createBean((BeanDeclaration)decl, (Class)this.defaultClass.orElse(null), (Object)parameter));
        }
    }
}

