/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.bean.xml.factory;

import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import lombok.Generated;
import org.anchoranalysis.core.functional.FunctionalList;
import org.apache.commons.configuration.tree.ConfigurationNode;

class HelperDescribeXmlNode {
    private static boolean isConfigAttribute(ConfigurationNode node) {
        return node.getName().startsWith("config-");
    }

    private static boolean isRegularAttribute(ConfigurationNode node) {
        return !HelperDescribeXmlNode.isConfigAttribute(node);
    }

    private static String describeAttributeKeyValue(ConfigurationNode node) {
        return String.format("%s=%s", node.getName(), node.getValue().toString());
    }

    private static void describeAttributes(Collection<ConfigurationNode> nodes, Predicate<ConfigurationNode> predicate, StringBuilder stringBuilder) {
        List nodesFiltered = FunctionalList.filterToList(nodes, predicate);
        if (nodesFiltered.isEmpty()) {
            return;
        }
        stringBuilder.append(" ");
        String attributeDesc = nodesFiltered.stream().map(HelperDescribeXmlNode::describeAttributeKeyValue).collect(Collectors.joining(", ", "[", "]"));
        stringBuilder.append(attributeDesc);
    }

    private static String describeLine(ConfigurationNode node) {
        StringBuilder sb = new StringBuilder();
        sb.append("");
        sb.append(node.getName());
        HelperDescribeXmlNode.describeAttributes(node.getAttributes(), HelperDescribeXmlNode::isRegularAttribute, sb);
        HelperDescribeXmlNode.describeAttributes(node.getAttributes(), HelperDescribeXmlNode::isConfigAttribute, sb);
        return sb.toString();
    }

    public static String describeXMLNode(ConfigurationNode node) {
        LinkedList<ConfigurationNode> listNames = new LinkedList<ConfigurationNode>();
        for (ConfigurationNode nodeCurrent = node; nodeCurrent != null; nodeCurrent = nodeCurrent.getParentNode()) {
            listNames.add(0, nodeCurrent);
        }
        StringBuilder sb = new StringBuilder();
        sb.append(" /---- Identifying XML Element ");
        sb.append(System.lineSeparator());
        String sep = System.lineSeparator() + "-| ";
        sb.append("-| " + listNames.stream().map(HelperDescribeXmlNode::describeLine).collect(Collectors.joining(sep)));
        sb.append(System.lineSeparator());
        sb.append(" \\----------- ");
        return sb.toString();
    }

    @Generated
    private HelperDescribeXmlNode() {
    }
}

