/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.bean.xml.factory;

import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.anchoranalysis.bean.xml.BeanXMLLoader;
import org.anchoranalysis.bean.xml.exception.BeanXMLException;
import org.anchoranalysis.bean.xml.factory.AnchorBeanFactory;
import org.anchoranalysis.core.system.path.ResolvePathAbsolute;
import org.apache.commons.configuration.beanutils.BeanDeclaration;
import org.apache.commons.configuration.beanutils.XMLBeanDeclaration;

public class IncludeBeanFactory
extends AnchorBeanFactory {
    public synchronized Object createBean(Class beanClass, BeanDeclaration decl, Object param) throws Exception {
        Path totalPath;
        XMLBeanDeclaration declaration = (XMLBeanDeclaration)decl;
        Path existingPath = Paths.get((String)param, new String[0]);
        if (Files.isSameFile(existingPath, totalPath = this.calculateTotalPath(existingPath, declaration))) {
            throw new BeanXMLException(String.format("Including file would cause overflow: %s", existingPath));
        }
        return BeanXMLLoader.loadBeanLocalized(totalPath, this.calculateXMLPath(declaration));
    }

    private String calculateXMLPath(XMLBeanDeclaration declaration) {
        String xmlPath = (String)declaration.getBeanProperties().get("xpath");
        if (xmlPath != null) {
            return xmlPath;
        }
        return "bean";
    }

    private Path calculateTotalPath(Path existingPath, XMLBeanDeclaration declaration) {
        String filePathStr = (String)declaration.getBeanProperties().get("filePath");
        Path filePath = Paths.get(filePathStr, new String[0]);
        return ResolvePathAbsolute.resolve((Path)existingPath, (Path)filePath);
    }
}

