/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.experiment.arguments;

import java.nio.file.Path;
import java.util.Optional;
import java.util.function.Consumer;
import org.anchoranalysis.core.exception.friendly.AnchorFriendlyRuntimeException;
import org.anchoranalysis.io.input.InputContextParameters;

public class InputArguments {
    private InputContextParameters contextParameters = new InputContextParameters();
    private boolean copyNonInputs = false;
    private Optional<Path> modelDirectory = Optional.empty();
    private Optional<Consumer<Path>> callUponDirectoryCreation = Optional.empty();

    public Path getModelDirectory() {
        return this.modelDirectory.orElseThrow(() -> new AnchorFriendlyRuntimeException("Model-directory is required but absent"));
    }

    public void assignModelDirectory(Path modelDirectory) {
        this.modelDirectory = Optional.of(modelDirectory);
    }

    public void assignCopyNonInputs() {
        this.copyNonInputs = true;
    }

    public void assignCallUponDirectoryCreation(Consumer<Path> consumer) {
        this.callUponDirectoryCreation = Optional.of(consumer);
    }

    public InputContextParameters getContextParameters() {
        return this.contextParameters;
    }

    public boolean isCopyNonInputs() {
        return this.copyNonInputs;
    }

    public Optional<Consumer<Path>> getCallUponDirectoryCreation() {
        return this.callUponDirectoryCreation;
    }
}

