/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.experiment.arguments;

import java.util.Optional;
import org.anchoranalysis.core.exception.OperationFailedException;
import org.anchoranalysis.core.index.range.IndexRangeNegative;
import org.anchoranalysis.core.index.range.IndexRangeNegativeFactory;
import org.anchoranalysis.experiment.ExperimentExecutionException;
import org.anchoranalysis.image.core.dimensions.size.suggestion.ImageSizeSuggestion;
import org.anchoranalysis.image.core.dimensions.size.suggestion.ImageSizeSuggestionFactory;
import org.anchoranalysis.image.core.dimensions.size.suggestion.SuggestionFormatException;

public class TaskArguments {
    private Optional<String> taskName = Optional.empty();
    private Optional<ImageSizeSuggestion> size;
    private Optional<Integer> maxNumberProcessors = Optional.empty();
    private Optional<IndexRangeNegative> groupIndexRange = Optional.empty();

    public TaskArguments() {
        this.size = Optional.empty();
    }

    public TaskArguments(Optional<ImageSizeSuggestion> size) {
        this.size = size;
    }

    public void assignTaskName(Optional<String> taskName) {
        this.taskName = taskName;
    }

    public void assignSize(String size) throws ExperimentExecutionException {
        try {
            this.size = Optional.of(ImageSizeSuggestionFactory.create((String)size));
        }
        catch (SuggestionFormatException e) {
            throw new ExperimentExecutionException(e);
        }
    }

    public void assignGroup(String groupRange) throws ExperimentExecutionException {
        try {
            if (groupRange.isEmpty()) {
                groupRange = "0";
            }
            this.groupIndexRange = Optional.of(IndexRangeNegativeFactory.parse((String)groupRange));
        }
        catch (OperationFailedException e) {
            throw new ExperimentExecutionException(e);
        }
    }

    public void assignMaxNumberProcessors(String numberProcessors) throws ExperimentExecutionException {
        try {
            Integer value = Integer.valueOf(numberProcessors);
            if (value <= 0) {
                throw TaskArguments.positiveNumberProcessorsException(numberProcessors);
            }
            this.maxNumberProcessors = Optional.of(value);
        }
        catch (NumberFormatException e) {
            throw TaskArguments.positiveNumberProcessorsException(numberProcessors);
        }
    }

    private static ExperimentExecutionException positiveNumberProcessorsException(String numberProcessors) {
        return new ExperimentExecutionException(String.format("The number of processors must be a positive integer. %s is invalid.", numberProcessors));
    }

    public Optional<String> getTaskName() {
        return this.taskName;
    }

    public Optional<ImageSizeSuggestion> getSize() {
        return this.size;
    }

    public Optional<Integer> getMaxNumberProcessors() {
        return this.maxNumberProcessors;
    }

    public Optional<IndexRangeNegative> getGroupIndexRange() {
        return this.groupIndexRange;
    }
}

