/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.experiment.bean.io;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.Collection;
import java.util.Optional;
import org.anchoranalysis.core.exception.OperationFailedException;
import org.anchoranalysis.core.exception.friendly.AnchorImpossibleSituationException;
import org.anchoranalysis.experiment.ExperimentExecutionException;
import org.anchoranalysis.experiment.task.ParametersExperiment;
import org.anchoranalysis.io.input.InputFromManager;
import org.anchoranalysis.io.input.InputsWithDirectory;
import org.anchoranalysis.io.input.file.NamedFile;

class CopyNonInputs {
    public static <T extends InputFromManager> Optional<Collection<NamedFile>> prepare(InputsWithDirectory<T> inputs, ParametersExperiment parameters) throws ExperimentExecutionException {
        if (parameters.getExecutionArguments().input().isCopyNonInputs()) {
            if (inputs.directory().isPresent()) {
                try {
                    Collection files = inputs.findAllNonInputFiles();
                    parameters.getLoggerExperiment().logFormatted("Preparing %d non-input files to copy to the output directory at end of experiment.", new Object[]{files.size()});
                    return Optional.of(files);
                }
                catch (OperationFailedException e) {
                    throw new AnchorImpossibleSituationException();
                }
            }
            throw new ExperimentExecutionException("Cannot determine non-input files to copy, as no input directory is known.");
        }
        return Optional.empty();
    }

    public static void copy(Collection<NamedFile> nonInputs, ParametersExperiment parameters) throws ExperimentExecutionException {
        parameters.getLoggerExperiment().logFormatted("Copying %d non-input files to the output directory.", new Object[]{nonInputs.size()});
        Path outputDirectory = parameters.getOutputter().getOutputDirectory();
        for (NamedFile toCopy : nonInputs) {
            try {
                Path source = toCopy.getFile().toPath();
                Path destination = CopyNonInputs.destinationPath(outputDirectory, toCopy.getIdentifier(), parameters);
                CopyNonInputs.copyMakeDirectories(source, destination);
            }
            catch (IOException e) {
                throw new ExperimentExecutionException(String.format("Failed to copy non-input file: %s", toCopy.getPath()), e);
            }
        }
    }

    private static Path destinationPath(Path outputDirectory, String identifier, ParametersExperiment parameters) {
        return outputDirectory.resolve(parameters.getExecutionArguments().output().getPrefixer().maybeSuppressDirectories(identifier, false));
    }

    private static void copyMakeDirectories(Path source, Path destination) throws IOException {
        destination.toFile().mkdirs();
        Files.copy(source, destination, StandardCopyOption.REPLACE_EXISTING);
    }

    private CopyNonInputs() {
    }
}

