/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.experiment.bean.io;

import com.owenfeehan.pathpatternfinder.PathPatternFinder;
import com.owenfeehan.pathpatternfinder.Pattern;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import org.anchoranalysis.bean.annotation.BeanField;
import org.anchoranalysis.core.exception.OperationFailedException;
import org.anchoranalysis.core.functional.FunctionalList;
import org.anchoranalysis.core.log.Divider;
import org.anchoranalysis.core.log.Logger;
import org.anchoranalysis.core.log.MessageLogger;
import org.anchoranalysis.core.time.OperationContext;
import org.anchoranalysis.core.value.LanguageUtilities;
import org.anchoranalysis.experiment.ExperimentExecutionException;
import org.anchoranalysis.experiment.bean.io.CopyNonInputs;
import org.anchoranalysis.experiment.bean.io.OutputExperiment;
import org.anchoranalysis.experiment.bean.log.LoggingDestination;
import org.anchoranalysis.experiment.bean.log.ToConsole;
import org.anchoranalysis.experiment.bean.processor.JobProcessor;
import org.anchoranalysis.experiment.bean.task.Task;
import org.anchoranalysis.experiment.io.ReplaceInputManager;
import org.anchoranalysis.experiment.io.ReplaceOutputManager;
import org.anchoranalysis.experiment.io.ReplaceTask;
import org.anchoranalysis.experiment.task.ParametersExperiment;
import org.anchoranalysis.experiment.task.TaskStatistics;
import org.anchoranalysis.io.input.InputFromManager;
import org.anchoranalysis.io.input.InputReadFailedException;
import org.anchoranalysis.io.input.InputsWithDirectory;
import org.anchoranalysis.io.input.bean.InputManager;
import org.anchoranalysis.io.input.bean.InputManagerParameters;
import org.anchoranalysis.io.input.file.NamedFile;
import org.anchoranalysis.io.output.bean.OutputManager;
import org.anchoranalysis.io.output.enabled.OutputEnabledMutable;
import org.anchoranalysis.io.output.enabled.multi.MultiLevelOutputEnabled;
import org.apache.commons.io.IOCase;

public class InputOutputExperiment<T extends InputFromManager, S>
extends OutputExperiment
implements ReplaceInputManager<T>,
ReplaceOutputManager,
ReplaceTask<T, S> {
    private static final String EXECUTION_TIME_COLLECTING_INPUTS = "Collecting inputs";
    private static final String OUTPUT_EXPERIMENT_LOG = "logExperiment";
    private static final String OUTPUT_JOB_LOG = "logJob";
    private static final Divider DIVIDER = new Divider();
    @BeanField
    private InputManager<T> input;
    @BeanField
    private JobProcessor<T, S> taskProcessor;
    @BeanField
    private LoggingDestination logTask = new ToConsole();
    @BeanField
    private String messageNoInputs = "No inputs exist. Nothing to do.";

    @Override
    public boolean useDetailedLogging() {
        if (this.isForceDetailedLogging() || !this.taskProcessor.hasVeryQuickPerInputExecution()) {
            return true;
        }
        return super.useDetailedLogging();
    }

    @Override
    public void replaceInputManager(InputManager<T> inputManager) throws OperationFailedException {
        this.input = inputManager;
    }

    @Override
    public void replaceOutputManager(OutputManager output) throws OperationFailedException {
        this.setOutput(output);
    }

    @Override
    public void replaceTask(Task<T, S> taskToReplace) throws OperationFailedException {
        this.taskProcessor.replaceTask(taskToReplace);
    }

    @Override
    protected Optional<TaskStatistics> executeExperimentWithParameters(ParametersExperiment parameters) throws ExperimentExecutionException {
        try {
            OperationContext operationContext = new OperationContext(parameters.getExecutionTimeRecorder(), new Logger((MessageLogger)parameters.getLoggerExperiment()));
            InputManagerParameters parametersInput = new InputManagerParameters(parameters.getExecutionArguments().inputContextParameters(), operationContext);
            if (parameters.isDetailedLogging()) {
                parameters.getLoggerExperiment().log(DIVIDER.withLabel("Inputs"));
            }
            InputsWithDirectory inputs = (InputsWithDirectory)parameters.getExecutionTimeRecorder().recordExecutionTime(EXECUTION_TIME_COLLECTING_INPUTS, () -> this.getInput().inputs(parametersInput));
            this.checkCompabilityInputs(inputs.inputs());
            if (!inputs.isEmpty()) {
                return Optional.of(this.executeExperimentWithInputs(inputs, parameters));
            }
            parameters.getLoggerExperiment().log(this.messageNoInputs);
            parameters.getLoggerExperiment().logEmptyLine();
            return Optional.empty();
        }
        catch (InputReadFailedException e) {
            throw new ExperimentExecutionException("An error occured while searching for inputs", e);
        }
    }

    @Override
    protected MultiLevelOutputEnabled defaultOutputs() {
        OutputEnabledMutable taskDefaultOutputs = this.taskProcessor.getTask().defaultOutputs();
        taskDefaultOutputs.addEnabledOutputFirst(new String[]{OUTPUT_EXPERIMENT_LOG, OUTPUT_JOB_LOG});
        return taskDefaultOutputs;
    }

    private TaskStatistics executeExperimentWithInputs(InputsWithDirectory<T> inputs, ParametersExperiment parameters) throws ExperimentExecutionException {
        parameters.setLoggerTaskCreator(this.logTask);
        if (parameters.isDetailedLogging()) {
            this.describeInputs(parameters.getLoggerExperiment(), inputs.inputs());
        }
        Optional<Collection<NamedFile>> nonInputs = CopyNonInputs.prepare(inputs, parameters);
        TaskStatistics statistics = this.taskProcessor.executeLogStatistics(parameters.getOutputter(), inputs.inputs(), parameters);
        if (nonInputs.isPresent()) {
            CopyNonInputs.copy(nonInputs.get(), parameters);
        }
        return statistics;
    }

    private void checkCompabilityInputs(List<T> listInputs) throws ExperimentExecutionException {
        for (InputFromManager inputObject : listInputs) {
            if (this.taskProcessor.isInputCompatibleWith(inputObject.getClass())) continue;
            throw new ExperimentExecutionException(String.format("Input has an incompatible class for the associated task: %s", inputObject.getClass().toString()));
        }
    }

    private void describeInputs(MessageLogger log, List<T> inputs) {
        List identifiers = FunctionalList.mapToList(inputs, InputFromManager::identifierAsPath);
        Pattern pattern = PathPatternFinder.findPatternPaths((List)identifiers, (IOCase)IOCase.SYSTEM, (boolean)true);
        String patternDescription = pattern.describeDetailed().replace("\\", "/");
        int numberInputs = inputs.size();
        log.logFormatted("The job has %d %s.", new Object[]{numberInputs, LanguageUtilities.pluralizeMaybe((long)numberInputs, (String)"input")});
        if (numberInputs > 1) {
            log.logEmptyLine();
            log.logFormatted("They are named with the pattern: %s", new Object[]{patternDescription});
        }
    }

    public InputManager<T> getInput() {
        return this.input;
    }

    public void setInput(InputManager<T> input) {
        this.input = input;
    }

    public JobProcessor<T, S> getTaskProcessor() {
        return this.taskProcessor;
    }

    public void setTaskProcessor(JobProcessor<T, S> taskProcessor) {
        this.taskProcessor = taskProcessor;
    }

    public LoggingDestination getLogTask() {
        return this.logTask;
    }

    public void setLogTask(LoggingDestination logTask) {
        this.logTask = logTask;
    }

    public String getMessageNoInputs() {
        return this.messageNoInputs;
    }

    public void setMessageNoInputs(String messageNoInputs) {
        this.messageNoInputs = messageNoInputs;
    }
}

