/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.experiment.bean.io;

import com.google.common.base.Preconditions;
import java.nio.file.Path;
import java.util.Optional;
import org.anchoranalysis.bean.annotation.BeanField;
import org.anchoranalysis.core.exception.CreateException;
import org.anchoranalysis.core.exception.OperationFailedException;
import org.anchoranalysis.core.exception.friendly.HasFriendlyErrorMessage;
import org.anchoranalysis.core.functional.OptionalFactory;
import org.anchoranalysis.core.time.ExecutionTimeRecorder;
import org.anchoranalysis.experiment.ExperimentExecutionException;
import org.anchoranalysis.experiment.arguments.ExecutionArguments;
import org.anchoranalysis.experiment.bean.Experiment;
import org.anchoranalysis.experiment.bean.identifier.ExperimentIdentifier;
import org.anchoranalysis.experiment.bean.io.OutputExperimentLogHelper;
import org.anchoranalysis.experiment.bean.log.LoggingDestination;
import org.anchoranalysis.experiment.bean.log.ToConsole;
import org.anchoranalysis.experiment.log.StatefulMessageLogger;
import org.anchoranalysis.experiment.task.ExperimentFeedbackContext;
import org.anchoranalysis.experiment.task.ParametersExperiment;
import org.anchoranalysis.experiment.task.TaskStatistics;
import org.anchoranalysis.experiment.time.DescribeExecutionTimeStatistics;
import org.anchoranalysis.experiment.time.ExecutionTimeRecorderFactory;
import org.anchoranalysis.io.generator.text.StringGenerator;
import org.anchoranalysis.io.output.bean.OutputManager;
import org.anchoranalysis.io.output.enabled.multi.MultiLevelOutputEnabled;
import org.anchoranalysis.io.output.outputter.BindFailedException;
import org.anchoranalysis.io.output.outputter.OutputWriteContext;
import org.anchoranalysis.io.output.outputter.OutputterChecked;
import org.anchoranalysis.io.output.path.prefixer.PathPrefixerException;
import org.anchoranalysis.io.output.recorded.MultiLevelRecordedOutputs;
import org.anchoranalysis.io.output.recorded.RecordedOutputsWithRules;
import org.apache.commons.lang.time.StopWatch;

public abstract class OutputExperiment
extends Experiment {
    public static final String OUTPUT_EXECUTION_TIME = "executionTime";
    @BeanField
    private OutputManager output;
    @BeanField
    private LoggingDestination logExperiment = new ToConsole();
    @BeanField
    private ExperimentIdentifier experimentIdentifier;
    @BeanField
    private boolean forceDetailedLogging = false;
    private MultiLevelRecordedOutputs recordedOutputs = new MultiLevelRecordedOutputs();

    @Override
    public Optional<Path> executeExperiment(ExecutionArguments arguments) throws ExperimentExecutionException {
        try {
            ParametersExperiment parameters = this.createParameters(arguments);
            this.doExperimentWithParameters(parameters);
            return Optional.of(parameters.getOutputter().getOutputDirectory());
        }
        catch (CreateException e) {
            throw new ExperimentExecutionException(e);
        }
    }

    @Override
    public boolean useDetailedLogging() {
        return this.forceDetailedLogging;
    }

    protected abstract Optional<TaskStatistics> executeExperimentWithParameters(ParametersExperiment var1) throws ExperimentExecutionException;

    protected abstract MultiLevelOutputEnabled defaultOutputs();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doExperimentWithParameters(ParametersExperiment parameters) throws ExperimentExecutionException {
        try {
            StopWatch stopWatchExperiment = new StopWatch();
            stopWatchExperiment.start();
            this.initBeforeExecution(parameters);
            Optional<TaskStatistics> taskStatistics = this.executeExperimentWithParameters(parameters);
            this.tidyUpAfterExecution(parameters, stopWatchExperiment, taskStatistics);
        }
        finally {
            parameters.getLoggerExperiment().close(true, false);
        }
    }

    private ParametersExperiment createParameters(ExecutionArguments arguments) throws CreateException {
        String experimentId = this.experimentIdentifierOrOmit(arguments);
        Optional experimentIdentifierForOutputPath = OptionalFactory.create((!arguments.output().isOmitExperimentIdentifier() ? 1 : 0) != 0, () -> experimentId);
        MultiLevelOutputEnabled outputsUnrecorded = this.defaultOutputs();
        RecordedOutputsWithRules outputs = new RecordedOutputsWithRules(this.recordedOutputs, outputsUnrecorded, arguments.output().getOutputEnabledDelta());
        Optional suggestedImageOutputFormat = arguments.output().getPrefixer().getSuggestedImageOutputFormat();
        try {
            MultiLevelOutputEnabled enabledOutputs = this.getOutput().determineEnabledOutputs(outputs);
            ExecutionTimeRecorder executionTimeRecorder = ExecutionTimeRecorderFactory.create(enabledOutputs.isOutputEnabled(OUTPUT_EXECUTION_TIME));
            OutputWriteContext writeContext = this.getOutput().createContextForWriting(suggestedImageOutputFormat, executionTimeRecorder);
            OutputterChecked rootOutputter = this.getOutput().createExperimentOutputter(experimentIdentifierForOutputPath, enabledOutputs, outputs.getRecordedOutputs(), writeContext, arguments.derivePathPrefixerContext(), arguments.input().getCallUponDirectoryCreation(), Optional.empty());
            Preconditions.checkArgument((boolean)rootOutputter.getSettings().hasBeenInitialized());
            ExperimentFeedbackContext feedbackContext = new ExperimentFeedbackContext(this.createLogger(rootOutputter, arguments), this.useDetailedLogging(), executionTimeRecorder);
            return new ParametersExperiment(arguments, experimentId, rootOutputter, this.getOutput().getPrefixer(), feedbackContext);
        }
        catch (PathPrefixerException e) {
            throw new CreateException("Cannot create parameters-context", (HasFriendlyErrorMessage)e);
        }
        catch (BindFailedException e) {
            throw new CreateException("Bind failed", (HasFriendlyErrorMessage)e);
        }
    }

    private String experimentIdentifierOrOmit(ExecutionArguments arguments) {
        return this.experimentIdentifier.identifier(arguments.task().getTaskName());
    }

    private StatefulMessageLogger createLogger(OutputterChecked rootOutputter, ExecutionArguments executionArguments) {
        return this.logExperiment.createWithConsoleFallback(rootOutputter, executionArguments, this.useDetailedLogging());
    }

    private void initBeforeExecution(ParametersExperiment parameters) throws ExperimentExecutionException {
        try {
            parameters.getLoggerExperiment().start();
        }
        catch (OperationFailedException e) {
            throw new ExperimentExecutionException(e);
        }
        OutputExperimentLogHelper.maybeLogStart(parameters);
        if (!parameters.getOutputter().getChecked().getSettings().hasBeenInitialized()) {
            throw new ExperimentExecutionException("Experiment has not been initialized");
        }
    }

    private void tidyUpAfterExecution(ParametersExperiment parameters, StopWatch stopWatchExperiment, Optional<TaskStatistics> taskStatistics) {
        stopWatchExperiment.stop();
        long totalExecutionTimeSeconds = stopWatchExperiment.getTime() / 1000L;
        if (taskStatistics.isPresent()) {
            parameters.getOutputter().writerSelective().write(OUTPUT_EXECUTION_TIME, StringGenerator::new, () -> DescribeExecutionTimeStatistics.describeExecutionTimes(((TaskStatistics)taskStatistics.get()).executionTimeTotal(), parameters.executionTimeStatistics(), totalExecutionTimeSeconds));
        }
        OutputExperimentLogHelper.maybeRecordedOutputs(this.recordedOutputs, parameters);
        OutputExperimentLogHelper.maybeLogCompleted(parameters, totalExecutionTimeSeconds);
    }

    public OutputManager getOutput() {
        return this.output;
    }

    public void setOutput(OutputManager output) {
        this.output = output;
    }

    public LoggingDestination getLogExperiment() {
        return this.logExperiment;
    }

    public void setLogExperiment(LoggingDestination logExperiment) {
        this.logExperiment = logExperiment;
    }

    public ExperimentIdentifier getExperimentIdentifier() {
        return this.experimentIdentifier;
    }

    public void setExperimentIdentifier(ExperimentIdentifier experimentIdentifier) {
        this.experimentIdentifier = experimentIdentifier;
    }

    public boolean isForceDetailedLogging() {
        return this.forceDetailedLogging;
    }

    public void setForceDetailedLogging(boolean forceDetailedLogging) {
        this.forceDetailedLogging = forceDetailedLogging;
    }
}

