/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.experiment.bean.io;

import org.anchoranalysis.core.log.Divider;
import org.anchoranalysis.experiment.bean.io.SummarizeRecordedOutputs;
import org.anchoranalysis.experiment.task.ParametersExperiment;
import org.anchoranalysis.io.output.recorded.MultiLevelRecordedOutputs;

class OutputExperimentLogHelper {
    private static final Divider DIVIDER = new Divider();

    public static void maybeLogStart(ParametersExperiment parameters) {
        if (parameters.isDetailedLogging()) {
            parameters.getLoggerExperiment().logFormatted("Experiment %s started writing to %s", new Object[]{parameters.getExperimentIdentifier(), parameters.getOutputter().getOutputDirectory()});
        }
    }

    public static void maybeRecordedOutputs(MultiLevelRecordedOutputs recordedOutputs, ParametersExperiment parameters) {
        if (parameters.isDetailedLogging()) {
            parameters.getLoggerExperiment().logFormatted("%s%n%s%n%s", new Object[]{DIVIDER.withLabel("Outputs"), new SummarizeRecordedOutputs(recordedOutputs).summarize(), DIVIDER.withoutLabel()});
        }
    }

    public static void maybeLogCompleted(ParametersExperiment parameters, long executionTimeSeconds) {
        if (parameters.isDetailedLogging()) {
            parameters.getLoggerExperiment().logFormatted("Experiment %s completed (%ds) writing to %s", new Object[]{parameters.getExperimentIdentifier(), executionTimeSeconds, parameters.getOutputter().getOutputDirectory()});
        }
    }

    private OutputExperimentLogHelper() {
    }
}

