/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.experiment.bean.processor;

import com.google.common.base.Preconditions;
import java.util.List;
import org.anchoranalysis.bean.annotation.BeanField;
import org.anchoranalysis.experiment.ExperimentExecutionException;
import org.anchoranalysis.experiment.arguments.ExecutionArguments;
import org.anchoranalysis.experiment.arguments.TaskArguments;
import org.anchoranalysis.experiment.bean.processor.JobProcessor;
import org.anchoranalysis.experiment.bean.processor.ParallelProcessor;
import org.anchoranalysis.experiment.bean.processor.SequentialProcessor;
import org.anchoranalysis.experiment.task.ParametersExperiment;
import org.anchoranalysis.experiment.task.TaskStatistics;
import org.anchoranalysis.io.input.InputFromManager;
import org.anchoranalysis.io.output.outputter.Outputter;

public class DebugDependentProcessor<T extends InputFromManager, S>
extends JobProcessor<T, S> {
    @BeanField
    private int maxNumberProcessors = 64;
    @BeanField
    private int keepProcessorsFree = 1;

    @Override
    protected TaskStatistics execute(Outputter rootOutputter, List<T> inputs, ParametersExperiment parametersExperiment) throws ExperimentExecutionException {
        Preconditions.checkArgument((boolean)rootOutputter.getChecked().getSettings().hasBeenInitialized());
        JobProcessor<T, S> processor = this.createProcessor(parametersExperiment.getExecutionArguments());
        return processor.execute(rootOutputter, inputs, parametersExperiment);
    }

    private JobProcessor<T, S> createProcessor(ExecutionArguments arguments) {
        if (arguments.isDebugModeEnabled()) {
            return this.createSequentialProcessor();
        }
        return this.creareParallelProcessor(arguments.task());
    }

    private SequentialProcessor<T, S> createSequentialProcessor() {
        SequentialProcessor processor = new SequentialProcessor();
        processor.setTask(this.getTask());
        processor.setSuppressExceptions(this.isSuppressExceptions());
        return processor;
    }

    private ParallelProcessor<T, S> creareParallelProcessor(TaskArguments arguments) {
        ParallelProcessor processor = new ParallelProcessor();
        processor.setMaxNumberProcessors(this.maxNumberProcessors(arguments));
        processor.setTask(this.getTask());
        processor.setSuppressExceptions(this.isSuppressExceptions());
        processor.setKeepProcessorsFree(this.keepProcessorsFree);
        return processor;
    }

    private int maxNumberProcessors(TaskArguments arguments) {
        if (arguments.getMaxNumberProcessors().isPresent()) {
            return arguments.getMaxNumberProcessors().get();
        }
        return this.maxNumberProcessors;
    }

    public int getMaxNumberProcessors() {
        return this.maxNumberProcessors;
    }

    public void setMaxNumberProcessors(int maxNumberProcessors) {
        this.maxNumberProcessors = maxNumberProcessors;
    }

    public int getKeepProcessorsFree() {
        return this.keepProcessorsFree;
    }

    public void setKeepProcessorsFree(int keepProcessorsFree) {
        this.keepProcessorsFree = keepProcessorsFree;
    }
}

