/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.experiment.bean.processor;

import java.util.List;
import java.util.Optional;
import org.anchoranalysis.core.log.MessageLogger;
import org.anchoranalysis.experiment.ExperimentExecutionException;
import org.anchoranalysis.experiment.JobExecutionException;
import org.anchoranalysis.experiment.bean.processor.JobProcessor;
import org.anchoranalysis.experiment.bean.processor.ProcessorChecker;
import org.anchoranalysis.experiment.bean.processor.ProcessorUtilities;
import org.anchoranalysis.experiment.log.StatefulMessageLogger;
import org.anchoranalysis.experiment.task.ErrorReporterForTask;
import org.anchoranalysis.experiment.task.ParametersExperiment;
import org.anchoranalysis.experiment.task.ParametersUnbound;
import org.anchoranalysis.experiment.task.TaskStatistics;
import org.anchoranalysis.experiment.task.processor.MonitoredSequentialExecutor;
import org.anchoranalysis.inference.concurrency.ConcurrencyPlan;
import org.anchoranalysis.io.input.InputFromManager;
import org.anchoranalysis.io.output.outputter.Outputter;

public class SequentialProcessor<T extends InputFromManager, S>
extends JobProcessor<T, S> {
    @Override
    protected TaskStatistics execute(Outputter rootOutputter, List<T> inputs, ParametersExperiment parametersExperiment) throws ExperimentExecutionException {
        ProcessorChecker.checkAtLeastOneInput(inputs);
        ConcurrencyPlan concurrencyPlan = ConcurrencyPlan.singleCPUProcessor();
        Object sharedState = this.getTask().beforeAnyJobIsExecuted(rootOutputter, concurrencyPlan, inputs, parametersExperiment);
        TaskStatistics statistics = this.executeAllJobs(inputs, sharedState, parametersExperiment, ProcessorUtilities.loggerForMonitor(parametersExperiment));
        this.getTask().afterAllJobsAreExecuted(sharedState, parametersExperiment.getContext());
        return statistics;
    }

    private TaskStatistics executeAllJobs(List<T> inputs, S sharedState, ParametersExperiment parametersExperiment, Optional<MessageLogger> loggerMonitor) {
        MonitoredSequentialExecutor<InputFromManager> executor = new MonitoredSequentialExecutor<InputFromManager>(object -> this.executeJobAndLog(object, sharedState, parametersExperiment), InputFromManager::identifier, loggerMonitor, false);
        return executor.executeEachWithMonitor("Job: ", inputs);
    }

    private boolean executeJobAndLog(T input, S sharedState, ParametersExperiment parametersExperiment) {
        StatefulMessageLogger logger = parametersExperiment.getLoggerExperiment();
        ErrorReporterForTask errorReporter = new ErrorReporterForTask(logger);
        try {
            ParametersUnbound<T, S> parametersUnbound = new ParametersUnbound<T, S>(parametersExperiment, input, sharedState, this.isSuppressExceptions());
            return this.getTask().executeJob(parametersUnbound);
        }
        catch (JobExecutionException e) {
            errorReporter.recordError(SequentialProcessor.class, (Throwable)((Object)e));
            return false;
        }
    }
}

