/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.experiment.bean.processor;

import java.util.function.DoubleSupplier;
import org.anchoranalysis.core.log.MessageLogger;
import org.anchoranalysis.core.value.LanguageUtilities;
import org.anchoranalysis.experiment.task.TaskStatistics;
import org.anchoranalysis.math.arithmetic.RunningSum;

class StatisticsLogger {
    private static final String JOB_WORD = "job";
    private MessageLogger logger;

    public void logStatisticsDescription(TaskStatistics statistics) {
        if (statistics.allSuccessful()) {
            this.logMessageAboutTasks("All ", statistics.numberCompletedSuccess(), " completed successfully.", () -> ((RunningSum)statistics.executionTimeTotal()).mean());
        } else {
            this.logMessageAboutTasks("", statistics.numberCompletedSuccess(), String.format(" out of %d completed successfully.", statistics.numberTotalScheduledJobs()), statistics::meanExecutionTimeSuccess);
            this.logMessageAboutTasks("", statistics.numberCompletedFailed(), " failed.", statistics::meanExecutionTimeFailed);
            long numNotCompleted = statistics.numberNotCompleted();
            if (numNotCompleted > 0L) {
                this.logger.logFormatted("%s were never submitted.", new Object[]{StatisticsLogger.maybePluralizeJobs(numNotCompleted)});
            }
        }
    }

    private void logMessageAboutTasks(String prefix, long numTasks, String suffix, DoubleSupplier executionTimeMs) {
        this.logMessageWithExecutionTime(prefix + StatisticsLogger.maybePluralizeJobs(numTasks) + suffix, numTasks > 0L, numTasks > 1L, executionTimeMs);
    }

    private void logMessageWithExecutionTime(String message, boolean showExecutionTime, boolean moreThanOneJob, DoubleSupplier executionTimeMillis) {
        if (showExecutionTime) {
            double execTimeSeconds = executionTimeMillis.getAsDouble() / 1000.0;
            message = message + String.format(" The %sexecution time was %.3f s.", this.maybeIncludeAverage(moreThanOneJob), execTimeSeconds);
        }
        this.logger.log(message);
    }

    private String maybeIncludeAverage(boolean moreThanOneJob) {
        return moreThanOneJob ? "average " : "";
    }

    private static String maybePluralizeJobs(long number) {
        return LanguageUtilities.prefixPluralizeMaybe((long)number, (String)JOB_WORD);
    }

    public StatisticsLogger(MessageLogger logger) {
        this.logger = logger;
    }
}

