/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.experiment.bean.task;

import com.google.common.base.Preconditions;
import java.util.List;
import org.anchoranalysis.bean.AnchorBean;
import org.anchoranalysis.core.exception.friendly.AnchorFriendlyCheckedException;
import org.anchoranalysis.core.log.MessageLogger;
import org.anchoranalysis.core.log.error.ErrorReporter;
import org.anchoranalysis.core.system.MemoryUtilities;
import org.anchoranalysis.experiment.ExperimentExecutionException;
import org.anchoranalysis.experiment.JobExecutionException;
import org.anchoranalysis.experiment.bean.task.TaskOutputterFactory;
import org.anchoranalysis.experiment.log.StatefulMessageLogger;
import org.anchoranalysis.experiment.task.ErrorReporterForTask;
import org.anchoranalysis.experiment.task.InputBound;
import org.anchoranalysis.experiment.task.InputOutputContextStateful;
import org.anchoranalysis.experiment.task.InputTypesExpected;
import org.anchoranalysis.experiment.task.ParametersExperiment;
import org.anchoranalysis.experiment.task.ParametersUnbound;
import org.anchoranalysis.inference.concurrency.ConcurrencyPlan;
import org.anchoranalysis.io.input.InputFromManager;
import org.anchoranalysis.io.output.bean.enabled.IgnoreUnderscorePrefix;
import org.anchoranalysis.io.output.enabled.OutputEnabledMutable;
import org.anchoranalysis.io.output.enabled.single.SingleLevelOutputEnabled;
import org.anchoranalysis.io.output.outputter.InputOutputContext;
import org.anchoranalysis.io.output.outputter.Outputter;
import org.anchoranalysis.io.output.outputter.OutputterChecked;
import org.apache.commons.lang.time.StopWatch;

public abstract class Task<T extends InputFromManager, S>
extends AnchorBean<Task<T, S>> {
    public abstract boolean hasVeryQuickPerInputExecution();

    public abstract S beforeAnyJobIsExecuted(Outputter var1, ConcurrencyPlan var2, List<T> var3, ParametersExperiment var4) throws ExperimentExecutionException;

    public boolean executeJob(ParametersUnbound<T, S> parametersUnbound) throws JobExecutionException {
        OutputterChecked outputterTask = TaskOutputterFactory.createOutputterForTask((InputFromManager)parametersUnbound.getInput(), parametersUnbound.getParametersExperiment());
        Preconditions.checkArgument((boolean)outputterTask.getSettings().hasBeenInitialized());
        InputBound<T, S> parametersBound = this.bindOtherParameters(parametersUnbound, outputterTask);
        outputterTask.assignLogger(parametersBound.getLogger());
        return this.executeJobLogExceptions(parametersBound, parametersUnbound.isSuppressExceptions());
    }

    public abstract void afterAllJobsAreExecuted(S var1, InputOutputContext var2) throws ExperimentExecutionException;

    public boolean isInputCompatibleWith(Class<? extends InputFromManager> inputClass) {
        return this.inputTypesExpected().doesClassInheritFromAny(inputClass);
    }

    public abstract InputTypesExpected inputTypesExpected();

    public abstract void doJobOnInput(InputBound<T, S> var1) throws JobExecutionException;

    public OutputEnabledMutable defaultOutputs() {
        return new OutputEnabledMutable((SingleLevelOutputEnabled)IgnoreUnderscorePrefix.INSTANCE, new String[0]);
    }

    private InputBound<T, S> bindOtherParameters(ParametersUnbound<T, S> parametersUnbound, OutputterChecked outputterTaskChecked) {
        StatefulMessageLogger loggerJob = this.createJobLog(parametersUnbound.getParametersExperiment(), outputterTaskChecked);
        ErrorReporterForTask errorReporterJob = new ErrorReporterForTask(loggerJob);
        Outputter outputterTask = new Outputter(outputterTaskChecked, (ErrorReporter)errorReporterJob);
        return new InputBound<InputFromManager, S>((InputFromManager)parametersUnbound.getInput(), parametersUnbound.getSharedState(), parametersUnbound.getParametersExperiment().isDetailedLogging(), parametersUnbound.getParametersExperiment().getContext(), new InputOutputContextStateful(parametersUnbound.getParametersExperiment().getExecutionArguments(), outputterTask, parametersUnbound.getParametersExperiment().getExecutionTimeRecorder(), loggerJob, errorReporterJob));
    }

    private StatefulMessageLogger createJobLog(ParametersExperiment parameters, OutputterChecked outputterTask) {
        return parameters.getLoggerTaskCreator().createWithLogFallback(outputterTask, parameters.getLoggerExperiment(), parameters.getExecutionArguments(), parameters.isDetailedLogging());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private boolean executeJobLogExceptions(InputBound<T, S> parameters, boolean suppressExceptions) throws JobExecutionException {
        StatefulMessageLogger loggerJob = parameters.getLogReporterJob();
        StopWatch stopWatchFile = new StopWatch();
        stopWatchFile.start();
        boolean successfullyFinished = false;
        try {
            loggerJob.start();
            if (parameters.isDetailedLogging()) {
                loggerJob.logFormatted("File processing started: %s", new Object[]{((InputFromManager)parameters.getInput()).identifier()});
            }
            this.executeJobAdditionalOutputs(parameters);
            successfullyFinished = true;
        }
        catch (AnchorFriendlyCheckedException e) {
            parameters.getLogger().errorReporter().recordError(Task.class, e.friendlyMessageHierarchy());
            Task.processExceptionAfterRecordingError(loggerJob, suppressExceptions, e);
            stopWatchFile.stop();
            if (parameters.isDetailedLogging()) {
                loggerJob.logFormatted("File processing ended:   %s (time taken = %ds)", new Object[]{((InputFromManager)parameters.getInput()).identifier(), stopWatchFile.getTime() / 1000L});
                MemoryUtilities.logMemoryUsage((String)"End file processing", (MessageLogger)loggerJob);
            }
            loggerJob.close(successfullyFinished, parameters.getLogger().errorReporter().hasWarningOccurred());
        }
        catch (Throwable e2) {
            parameters.getLogger().errorReporter().recordError(Task.class, e2);
            Task.processExceptionAfterRecordingError(loggerJob, suppressExceptions, e2);
            {
                catch (Throwable throwable) {
                    stopWatchFile.stop();
                    if (parameters.isDetailedLogging()) {
                        loggerJob.logFormatted("File processing ended:   %s (time taken = %ds)", new Object[]{((InputFromManager)parameters.getInput()).identifier(), stopWatchFile.getTime() / 1000L});
                        MemoryUtilities.logMemoryUsage((String)"End file processing", (MessageLogger)loggerJob);
                    }
                    loggerJob.close(successfullyFinished, parameters.getLogger().errorReporter().hasWarningOccurred());
                    throw throwable;
                }
            }
            stopWatchFile.stop();
            if (parameters.isDetailedLogging()) {
                loggerJob.logFormatted("File processing ended:   %s (time taken = %ds)", new Object[]{((InputFromManager)parameters.getInput()).identifier(), stopWatchFile.getTime() / 1000L});
                MemoryUtilities.logMemoryUsage((String)"End file processing", (MessageLogger)loggerJob);
            }
            loggerJob.close(successfullyFinished, parameters.getLogger().errorReporter().hasWarningOccurred());
        }
        stopWatchFile.stop();
        if (parameters.isDetailedLogging()) {
            loggerJob.logFormatted("File processing ended:   %s (time taken = %ds)", new Object[]{((InputFromManager)parameters.getInput()).identifier(), stopWatchFile.getTime() / 1000L});
            MemoryUtilities.logMemoryUsage((String)"End file processing", (MessageLogger)loggerJob);
        }
        loggerJob.close(successfullyFinished, parameters.getLogger().errorReporter().hasWarningOccurred());
        return successfullyFinished;
    }

    private static void processExceptionAfterRecordingError(StatefulMessageLogger loggerJob, boolean suppressExceptions, Throwable e) throws JobExecutionException {
        loggerJob.log("This error was fatal. The specific job will end early, but the experiment will otherwise continue.");
        if (!suppressExceptions) {
            throw new JobExecutionException("Job encountered a fatal error", e);
        }
    }

    private void executeJobAdditionalOutputs(InputBound<T, S> parameters) throws JobExecutionException {
        try {
            this.doJobOnInput(parameters);
        }
        catch (ClassCastException e) {
            throw new JobExecutionException("Could not cast one class to another. Have you used a compatible input-manager for the task?", e);
        }
        finally {
            ((InputFromManager)parameters.getInput()).close(parameters.getLogger().errorReporter());
        }
    }
}

