/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.experiment.log;

import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.anchoranalysis.core.exception.OperationFailedException;
import org.anchoranalysis.core.log.MessageLogger;
import org.anchoranalysis.experiment.log.StatefulMessageLogger;

public class MultipleLoggers
implements StatefulMessageLogger {
    private final List<StatefulMessageLogger> list;

    public MultipleLoggers(Stream<StatefulMessageLogger> stream) {
        this.list = stream.collect(Collectors.toList());
    }

    @Override
    public void start() throws OperationFailedException {
        for (StatefulMessageLogger logger : this.list) {
            assert (logger != null);
            logger.start();
        }
    }

    public void log(String message) {
        for (StatefulMessageLogger logger : this.list) {
            assert (logger != null);
            logger.log(message);
        }
    }

    @Override
    public void close(boolean successful, boolean warningOccurred) {
        for (StatefulMessageLogger logger : this.list) {
            logger.close(successful, warningOccurred);
        }
    }

    public void logFormatted(String formatString, Object ... args) {
        for (MessageLogger messageLogger : this.list) {
            messageLogger.logFormatted(formatString, args);
        }
    }
}

