/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.experiment.task.processor;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.anchoranalysis.core.functional.OptionalFactory;
import org.anchoranalysis.experiment.task.TaskStatistics;
import org.anchoranalysis.experiment.task.processor.JobStateMonitor;
import org.anchoranalysis.experiment.task.processor.SubmittedJob;
import org.anchoranalysis.math.arithmetic.RunningSum;

public class ConcurrentJobMonitor
implements Iterable<SubmittedJob> {
    private final long totalNumberJobs;
    private List<SubmittedJob> list = new LinkedList<SubmittedJob>();

    public synchronized void add(SubmittedJob job) {
        this.list.add(job);
    }

    public synchronized String currentStateDescription() {
        long numberJobsCompleted = this.numberCompletedJobs();
        long numberJobsExecuting = this.numberExecutingJobs();
        long numberJobsRemaining = this.totalNumberJobs - numberJobsCompleted - numberJobsExecuting;
        return String.format("%3d compl, %3d exec, %3d rem of %3d", numberJobsCompleted, numberJobsExecuting, numberJobsRemaining, this.totalNumberJobs);
    }

    public synchronized Optional<String> describeUncompletedJobs(int fewerThanThreshold) {
        return OptionalFactory.create((this.numberUncompletedJobs() < (long)fewerThanThreshold ? 1 : 0) != 0, this::describeAllUncompletedTasks);
    }

    public synchronized long numberUncompletedJobs() {
        return this.totalNumberJobs - this.numberCompletedJobs();
    }

    public synchronized long numberCompletedJobs() {
        return this.numberJobs(JobStateMonitor::isCompleted);
    }

    public synchronized long numberCompletedSuccessfullyJobs() {
        return this.numberJobs(JobStateMonitor::isCompletedSuccessfully);
    }

    public synchronized long numberCompletedFailureJobs() {
        return this.numberJobs(JobStateMonitor::isCompletedFailure);
    }

    public synchronized long numberExecutingJobs() {
        return this.numberJobs(JobStateMonitor::isExecuting);
    }

    public synchronized TaskStatistics deriveStatistics() {
        return new TaskStatistics(this.getTotalNumberJobs(), this.runningSum(JobStateMonitor::isCompletedSuccessfully), this.runningSum(JobStateMonitor::isCompletedFailure));
    }

    @Override
    public Iterator<SubmittedJob> iterator() {
        return this.list.iterator();
    }

    private RunningSum runningSum(Predicate<JobStateMonitor> predicate) {
        return new RunningSum((double)this.sumExectionTime(predicate), this.numberJobs(predicate));
    }

    private long numberJobs(Predicate<JobStateMonitor> predicate) {
        return this.filteredJobs(predicate).count();
    }

    private long sumExectionTime(Predicate<JobStateMonitor> predicate) {
        return this.filteredJobs(predicate).mapToLong(job -> job.getJobState().getExecutionDuration()).sum();
    }

    private Stream<SubmittedJob> filteredJobs(Predicate<JobStateMonitor> predicate) {
        return this.list.stream().filter(job -> predicate.test(job.getJobState()));
    }

    private String describeAllUncompletedTasks() {
        StringBuilder builder = new StringBuilder();
        for (SubmittedJob job : this.list) {
            if (!job.getJobState().isExecuting()) continue;
            builder.append(String.format("%d(%s,%ds), ", job.getJobDescription().getNumber(), job.getJobDescription().getShortName(), job.getJobState().getExecutionDuration() / 1000));
        }
        return builder.toString();
    }

    public ConcurrentJobMonitor(long totalNumberJobs) {
        this.totalNumberJobs = totalNumberJobs;
    }

    public long getTotalNumberJobs() {
        return this.totalNumberJobs;
    }
}

