/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.experiment.task.processor;

import java.util.Optional;
import org.anchoranalysis.core.log.Divider;
import org.anchoranalysis.core.log.MessageLogger;
import org.anchoranalysis.experiment.task.processor.ConcurrentJobMonitor;
import org.anchoranalysis.experiment.task.processor.JobDescription;
import org.anchoranalysis.experiment.task.processor.JobStateMonitor;

public class JobStartStopLogger {
    private static final Divider DIVIDER = new Divider('#');
    private final String jobDescriptionText;
    private final boolean showHashSeperators;
    private final int showOngoingJobsLessThan;
    private final ConcurrentJobMonitor monitor;
    private final Optional<MessageLogger> logger;
    private final boolean disableLogMessages;

    public JobStartStopLogger(String jobDescriptionText, ConcurrentJobMonitor monitor, boolean showHashSeperators, int showOngoingJobsLessThan, Optional<MessageLogger> logger) {
        this.jobDescriptionText = jobDescriptionText;
        this.monitor = monitor;
        this.showHashSeperators = showHashSeperators;
        this.showOngoingJobsLessThan = showOngoingJobsLessThan;
        this.logger = logger;
        this.disableLogMessages = monitor.getTotalNumberJobs() <= 1L || !logger.isPresent();
    }

    public synchronized void logStart(JobDescription job) {
        if (this.disableLogMessages) {
            return;
        }
        this.logEvent("start", job, "     ");
    }

    public synchronized void logEnd(JobDescription job, JobStateMonitor monitor) {
        if (this.disableLogMessages) {
            return;
        }
        this.logEvent(monitor.isCompletedSuccessfully() ? "end  " : "ERROR", job, JobStartStopLogger.timeText(monitor));
    }

    private void logEvent(String eventWord, JobDescription job, String timeStr) {
        if (!this.logger.isPresent()) {
            return;
        }
        this.logWithDecoration(() -> this.logger.get().logFormatted("%s %4d:\t%s\t[%s]\t%s\t%s  %s", new Object[]{this.jobDescriptionText, job.getNumber(), eventWord, this.monitor.currentStateDescription(), timeStr, job.getShortName(), this.ongoingJobText()}));
    }

    private String ongoingJobText() {
        return this.showOngoingJobsLessThan > 0 ? this.monitor.describeUncompletedJobs(this.showOngoingJobsLessThan).orElse("") : "";
    }

    private void logWithDecoration(Runnable logFunction) {
        this.logMaybeDivider();
        logFunction.run();
        this.logMaybeDivider();
    }

    private void logMaybeDivider() {
        if (this.showHashSeperators) {
            this.logger.get().log(DIVIDER.withoutLabel());
        }
    }

    private static String timeText(JobStateMonitor jobState) {
        return String.format("(%ds)", jobState.getExecutionDuration() / 1000);
    }
}

