/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.experiment.task.processor;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import org.anchoranalysis.core.log.MessageLogger;
import org.anchoranalysis.experiment.task.TaskStatistics;
import org.anchoranalysis.experiment.task.processor.ConcurrentJobMonitor;
import org.anchoranalysis.experiment.task.processor.JobDescription;
import org.anchoranalysis.experiment.task.processor.JobStartStopLogger;
import org.anchoranalysis.experiment.task.processor.JobStateMonitor;
import org.anchoranalysis.experiment.task.processor.SubmittedJob;

public class MonitoredSequentialExecutor<T> {
    private Predicate<T> execFunc;
    private Function<T, String> dscrFunc;
    private Optional<MessageLogger> logger;
    private boolean showHashSeperators;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TaskStatistics executeEachWithMonitor(String logPrefix, List<T> inputs) {
        ConcurrentJobMonitor monitor = new ConcurrentJobMonitor(inputs.size());
        JobStartStopLogger jobLogger = new JobStartStopLogger(logPrefix, monitor, this.showHashSeperators, 0, this.logger);
        List<InputAfterSubmission> submittedInputs = this.mapToSubmitted(inputs, monitor);
        ListIterator<InputAfterSubmission> itr = submittedInputs.listIterator();
        while (itr.hasNext()) {
            InputAfterSubmission input = itr.next();
            try {
                input.executeInput(jobLogger);
            }
            finally {
                itr.remove();
            }
        }
        return monitor.deriveStatistics();
    }

    private List<InputAfterSubmission> mapToSubmitted(Collection<T> allInputs, ConcurrentJobMonitor monitor) {
        ArrayList<InputAfterSubmission> out = new ArrayList<InputAfterSubmission>();
        int count = 1;
        for (T input : allInputs) {
            JobDescription desc = new JobDescription(this.dscrFunc.apply(input), count++);
            JobStateMonitor state = new JobStateMonitor();
            SubmittedJob submittedJob = new SubmittedJob(desc, state);
            out.add(new InputAfterSubmission(input, submittedJob));
            monitor.add(submittedJob);
        }
        return out;
    }

    public MonitoredSequentialExecutor(Predicate<T> execFunc, Function<T, String> dscrFunc, Optional<MessageLogger> logger, boolean showHashSeperators) {
        this.execFunc = execFunc;
        this.dscrFunc = dscrFunc;
        this.logger = logger;
        this.showHashSeperators = showHashSeperators;
    }

    private final class InputAfterSubmission {
        private final T input;
        private final SubmittedJob job;

        public void executeInput(JobStartStopLogger jobLogger) {
            this.job.getJobState().markAsExecuting();
            jobLogger.logStart(this.job.getJobDescription());
            boolean success = MonitoredSequentialExecutor.this.execFunc.test(this.input);
            this.job.getJobState().markAsCompleted(success);
            jobLogger.logEnd(this.job.getJobDescription(), this.job.getJobState());
        }

        public InputAfterSubmission(T input, SubmittedJob job) {
            this.input = input;
            this.job = job;
        }

        public T getInput() {
            return this.input;
        }

        public SubmittedJob getJob() {
            return this.job;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof InputAfterSubmission)) {
                return false;
            }
            InputAfterSubmission other = (InputAfterSubmission)o;
            Object this$input = this.getInput();
            Object other$input = other.getInput();
            if (this$input == null ? other$input != null : !this$input.equals(other$input)) {
                return false;
            }
            SubmittedJob this$job = this.getJob();
            SubmittedJob other$job = other.getJob();
            return !(this$job == null ? other$job != null : !((Object)this$job).equals(other$job));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Object $input = this.getInput();
            result = result * 59 + ($input == null ? 43 : $input.hashCode());
            SubmittedJob $job = this.getJob();
            result = result * 59 + ($job == null ? 43 : ((Object)$job).hashCode());
            return result;
        }

        public String toString() {
            return "MonitoredSequentialExecutor.InputAfterSubmission(input=" + this.getInput() + ", job=" + this.getJob() + ")";
        }
    }
}

