/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.experiment.time;

import org.anchoranalysis.core.log.Divider;
import org.anchoranalysis.core.time.RecordedExecutionTimes;
import org.anchoranalysis.experiment.time.DescribeOperations;
import org.anchoranalysis.experiment.time.RecordedOperationHelper;
import org.anchoranalysis.math.arithmetic.RunningSum;

public class DescribeExecutionTimeStatistics {
    private static final Divider DIVIDER = new Divider(116);
    private static final String AVERAGE_TOTAL_LINE = "\t\t\t\t\t\t\t\t\t\t\t\t\t\taverage       total      (ignoring any parallelism)";

    public static String describeExecutionTimes(RunningSum taskTotal, RecordedExecutionTimes operations, long executionTimeTotal) {
        StringBuilder builder = new StringBuilder();
        builder.append(String.format("The total execution time was %d seconds, including any parallelism.", executionTimeTotal));
        builder.append(System.lineSeparator());
        builder.append(DIVIDER.withLabel("Execution Time"));
        builder.append(System.lineSeparator());
        builder.append(AVERAGE_TOTAL_LINE);
        builder.append(System.lineSeparator());
        builder.append(DescribeOperations.individual(RecordedOperationHelper.create("* Entire Job *", taskTotal, 0)));
        builder.append(System.lineSeparator());
        builder.append(DescribeOperations.allOperations(operations));
        builder.append(DIVIDER.withoutLabel());
        return builder.toString();
    }

    private DescribeExecutionTimeStatistics() {
    }
}

