/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.experiment.arguments;

import java.nio.file.Path;
import java.util.Optional;
import lombok.Generated;
import org.anchoranalysis.core.functional.OptionalFactory;
import org.anchoranalysis.experiment.arguments.InputArguments;
import org.anchoranalysis.experiment.arguments.OutputArguments;
import org.anchoranalysis.experiment.arguments.TaskArguments;
import org.anchoranalysis.io.input.InputContextParameters;
import org.anchoranalysis.io.input.bean.DebugModeParameters;
import org.anchoranalysis.io.output.path.prefixer.PathPrefixerContext;
import org.anchoranalysis.io.output.path.prefixer.PathPrefixerException;

public class ExecutionArguments {
    private final InputArguments input = new InputArguments();
    private final OutputArguments output = new OutputArguments();
    private final TaskArguments task;
    private Optional<DebugModeParameters> debugModeParameters = Optional.empty();

    public ExecutionArguments() {
        this.task = new TaskArguments();
    }

    public ExecutionArguments(Path modelDirectory, TaskArguments task) {
        this.input.assignModelDirectory(modelDirectory);
        this.task = task;
    }

    public InputContextParameters inputContextParameters() {
        return this.input.getContextParameters();
    }

    public PathPrefixerContext derivePathPrefixerContext() throws PathPrefixerException {
        return new PathPrefixerContext(this.isDebugModeEnabled(), this.output.getPrefixer());
    }

    public void activateDebugMode(String debugContains) {
        Optional debugContainsAsOptional = OptionalFactory.create((!debugContains.isEmpty() ? 1 : 0) != 0, () -> debugContains);
        this.debugModeParameters = Optional.of(new DebugModeParameters(debugContainsAsOptional));
    }

    public boolean isDebugModeEnabled() {
        return this.debugModeParameters.isPresent();
    }

    @Generated
    public InputArguments input() {
        return this.input;
    }

    @Generated
    public OutputArguments output() {
        return this.output;
    }

    @Generated
    public TaskArguments task() {
        return this.task;
    }
}

