/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.experiment.bean.identifier;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Optional;
import lombok.Generated;
import org.anchoranalysis.bean.annotation.BeanField;
import org.anchoranalysis.core.functional.OptionalFactory;
import org.anchoranalysis.experiment.bean.identifier.ExperimentIdentifier;
import org.anchoranalysis.experiment.bean.identifier.IdentifierUtilities;

public class ExperimentIdentifierAuto
extends ExperimentIdentifier {
    @BeanField
    private String fallbackName = "experiment";
    @BeanField
    private boolean day = true;
    @BeanField
    private boolean time = true;
    @BeanField
    private boolean second = true;
    private static final String FORMAT_DAY = "yyyy.MM.dd";
    private static final String FORMAT_TIME_BASE = "HH.mm";
    private static final String FORMAT_TIME_SECOND = "ss";

    @Override
    public String identifier(Optional<String> taskName) {
        return IdentifierUtilities.identifierFromNameVersion(this.determineExperimentName(taskName), this.determineVersion());
    }

    private String determineExperimentName(Optional<String> taskName) {
        return taskName.map(name -> ExperimentIdentifierAuto.removeSpecialChars(ExperimentIdentifierAuto.finalPartOfTaskName(name))).orElse(this.fallbackName);
    }

    private Optional<String> determineVersion() {
        return this.createFormatterPatternStr().map(DateTimeFormatter::ofPattern).map(formatter -> formatter.format(LocalDateTime.now()));
    }

    private Optional<String> createFormatterPatternStr() {
        if (this.day) {
            if (this.time) {
                return Optional.of("yyyy.MM.dd." + this.timePattern());
            }
            return Optional.of(FORMAT_DAY);
        }
        return OptionalFactory.create((boolean)this.time, this::timePattern);
    }

    private String timePattern() {
        if (this.second) {
            return "HH.mm.ss";
        }
        return FORMAT_TIME_BASE;
    }

    private static String finalPartOfTaskName(String taskName) {
        Path path = Paths.get(taskName, new String[0]);
        return path.getName(path.getNameCount() - 1).toString();
    }

    private static String removeSpecialChars(String str) {
        return str.replaceAll("[^a-zA-Z]+", "");
    }

    @Generated
    public String getFallbackName() {
        return this.fallbackName;
    }

    @Generated
    public void setFallbackName(String fallbackName) {
        this.fallbackName = fallbackName;
    }

    @Generated
    public boolean isDay() {
        return this.day;
    }

    @Generated
    public void setDay(boolean day) {
        this.day = day;
    }

    @Generated
    public boolean isTime() {
        return this.time;
    }

    @Generated
    public void setTime(boolean time) {
        this.time = time;
    }

    @Generated
    public boolean isSecond() {
        return this.second;
    }

    @Generated
    public void setSecond(boolean second) {
        this.second = second;
    }
}

