/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.experiment.bean.io;

import java.util.Map;
import lombok.Generated;
import org.anchoranalysis.io.output.recorded.MultiLevelRecordedOutputs;
import org.anchoranalysis.io.output.recorded.RecordedOutputs;

class SummarizeRecordedOutputs {
    private MultiLevelRecordedOutputs recordedOutputs;

    public String summarize() {
        if (this.recordedOutputs.first().isEmpty()) {
            return "No outputs were written as no possible outputs exist.";
        }
        if (this.recordedOutputs.first().hasAtLeastOneEnabled()) {
            return this.summarizeWritten();
        }
        return String.format("No outputs were written.%nPossible outputs are: %s.", this.recordedOutputs.first().summarizeDisabled());
    }

    private String summarizeWritten() {
        StringBuilder builder = new StringBuilder();
        if (this.recordedOutputs.hasAtLeastOneDisabled()) {
            this.addLineSummary("Enabled", true, builder);
            builder.append(System.lineSeparator());
            this.addLineSummary("Disabled", false, builder);
        } else {
            this.addLineSummary("All possible outputs were written", true, builder);
        }
        return builder.toString();
    }

    private void addLineSummary(String prefix, boolean written, StringBuilder builder) {
        builder.append(prefix);
        builder.append(":\t");
        builder.append(this.recordedOutputs.first().summarizeMultiplex(written));
        this.addSecondLevelLines(builder, written);
    }

    private void addSecondLevelLines(StringBuilder builder, boolean written) {
        for (Map.Entry entry : this.recordedOutputs.secondEntries()) {
            if (!((RecordedOutputs)entry.getValue()).hasAtLeastOneMultiplex(written)) continue;
            builder.append(System.lineSeparator());
            builder.append("|- ");
            builder.append((String)entry.getKey());
            builder.append("\t");
            builder.append(((RecordedOutputs)entry.getValue()).summarizeMultiplex(written));
        }
    }

    @Generated
    public SummarizeRecordedOutputs(MultiLevelRecordedOutputs recordedOutputs) {
        this.recordedOutputs = recordedOutputs;
    }
}

