/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.experiment.bean.processor;

import java.util.List;
import lombok.Generated;
import org.anchoranalysis.bean.AnchorBean;
import org.anchoranalysis.bean.annotation.BeanField;
import org.anchoranalysis.core.exception.OperationFailedException;
import org.anchoranalysis.core.log.Divider;
import org.anchoranalysis.experiment.ExperimentExecutionException;
import org.anchoranalysis.experiment.bean.processor.StatisticsLogger;
import org.anchoranalysis.experiment.bean.task.Task;
import org.anchoranalysis.experiment.io.ReplaceTask;
import org.anchoranalysis.experiment.task.ParametersExperiment;
import org.anchoranalysis.experiment.task.TaskStatistics;
import org.anchoranalysis.io.input.InputFromManager;
import org.anchoranalysis.io.output.outputter.Outputter;

public abstract class JobProcessor<T extends InputFromManager, S>
extends AnchorBean<JobProcessor<T, S>>
implements ReplaceTask<T, S> {
    private static final Divider DIVIDER = new Divider();
    @BeanField
    private Task<T, S> task;
    @BeanField
    private boolean suppressExceptions = true;

    public TaskStatistics executeLogStatistics(Outputter rootOutputter, List<T> inputs, ParametersExperiment parametersExperiment) throws ExperimentExecutionException {
        if (parametersExperiment.isDetailedLogging()) {
            parametersExperiment.getLoggerExperiment().log(DIVIDER.withLabel("Processing"));
        }
        TaskStatistics statistics = this.execute(rootOutputter, inputs, parametersExperiment);
        if (parametersExperiment.isDetailedLogging()) {
            JobProcessor.logStatistics(statistics, parametersExperiment);
        }
        return statistics;
    }

    @Override
    public void replaceTask(Task<T, S> taskToReplace) throws OperationFailedException {
        if (ReplaceTask.class.isAssignableFrom(((Object)this.task).getClass())) {
            ((ReplaceTask)((Object)this.task)).replaceTask(taskToReplace);
        } else {
            this.task = taskToReplace;
        }
    }

    public boolean isInputCompatibleWith(Class<? extends InputFromManager> inputClass) {
        return this.task.isInputCompatibleWith(inputClass);
    }

    public boolean hasVeryQuickPerInputExecution() {
        return this.task.hasVeryQuickPerInputExecution();
    }

    protected abstract TaskStatistics execute(Outputter var1, List<T> var2, ParametersExperiment var3) throws ExperimentExecutionException;

    private static void logStatistics(TaskStatistics stats, ParametersExperiment parametersExperiment) {
        StatisticsLogger statisticsLogger = new StatisticsLogger(parametersExperiment.getLoggerExperiment());
        statisticsLogger.logStatisticsDescription(stats);
    }

    @Generated
    public Task<T, S> getTask() {
        return this.task;
    }

    @Generated
    public void setTask(Task<T, S> task) {
        this.task = task;
    }

    @Generated
    public boolean isSuppressExceptions() {
        return this.suppressExceptions;
    }

    @Generated
    public void setSuppressExceptions(boolean suppressExceptions) {
        this.suppressExceptions = suppressExceptions;
    }
}

