/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.experiment.bean.processor;

import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import lombok.Generated;
import org.anchoranalysis.bean.BeanInstanceMap;
import org.anchoranalysis.bean.annotation.BeanField;
import org.anchoranalysis.bean.exception.BeanMisconfiguredException;
import org.anchoranalysis.core.value.LanguageUtilities;
import org.anchoranalysis.experiment.ExperimentExecutionException;
import org.anchoranalysis.experiment.bean.processor.JobProcessor;
import org.anchoranalysis.experiment.bean.processor.ProcessorChecker;
import org.anchoranalysis.experiment.bean.processor.ProcessorUtilities;
import org.anchoranalysis.experiment.task.ParametersExperiment;
import org.anchoranalysis.experiment.task.ParametersUnbound;
import org.anchoranalysis.experiment.task.TaskStatistics;
import org.anchoranalysis.experiment.task.processor.CallableJob;
import org.anchoranalysis.experiment.task.processor.ConcurrentJobMonitor;
import org.anchoranalysis.experiment.task.processor.JobDescription;
import org.anchoranalysis.experiment.task.processor.JobStartStopLogger;
import org.anchoranalysis.experiment.task.processor.JobStateMonitor;
import org.anchoranalysis.experiment.task.processor.SubmittedJob;
import org.anchoranalysis.inference.concurrency.ConcurrencyPlan;
import org.anchoranalysis.io.input.InputFromManager;
import org.anchoranalysis.io.output.outputter.Outputter;

public class ParallelProcessor<T extends InputFromManager, S>
extends JobProcessor<T, S> {
    @BeanField
    private int maxNumberProcessors = 64;
    @BeanField
    private int showOngoingJobsLessThan = 0;
    @BeanField
    private int keepProcessorsFree = 1;
    @BeanField
    private int numberGPUProcessors = 1;
    private BeanInstanceMap defaultInstances;

    public void checkMisconfigured(BeanInstanceMap defaultInstances) throws BeanMisconfiguredException {
        super.checkMisconfigured(defaultInstances);
        this.defaultInstances = defaultInstances;
    }

    @Override
    protected TaskStatistics execute(Outputter rootOutputter, List<T> inputs, ParametersExperiment parametersExperiment) throws ExperimentExecutionException {
        int numberInputs = inputs.size();
        ProcessorChecker.checkAtLeastOneInput(inputs);
        ConcurrencyPlan concurrencyPlan = this.createConcurrencyPlan(parametersExperiment);
        Object sharedState = this.getTask().beforeAnyJobIsExecuted(rootOutputter, concurrencyPlan, inputs, parametersExperiment);
        ExecutorService executorService = Executors.newFixedThreadPool(concurrencyPlan.numberCPUs());
        ConcurrentJobMonitor monitor = new ConcurrentJobMonitor(inputs.size());
        this.submitAllJobs(inputs, parametersExperiment, executorService, sharedState, monitor);
        executorService.shutdown();
        while (!executorService.isTerminated()) {
        }
        this.logWhenIrregularlyEnded(monitor, parametersExperiment, numberInputs);
        this.getTask().afterAllJobsAreExecuted(sharedState, parametersExperiment.getContext());
        return monitor.deriveStatistics();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void submitAllJobs(List<T> inputs, ParametersExperiment parametersExperiment, ExecutorService executorService, S sharedState, ConcurrentJobMonitor monitor) {
        int count = 1;
        ArrayList<T> inputsModifiable = new ArrayList<T>(inputs);
        ListIterator iterator = inputsModifiable.listIterator();
        while (iterator.hasNext()) {
            InputFromManager input = (InputFromManager)iterator.next();
            try {
                this.submitJob(executorService, input, count, sharedState, parametersExperiment, monitor);
                ++count;
            }
            finally {
                iterator.remove();
            }
        }
    }

    private void submitJob(ExecutorService executorService, T input, int index, S sharedState, ParametersExperiment parametersExperiment, ConcurrentJobMonitor monitor) {
        JobDescription description = new JobDescription(input.identifier(), index);
        ParametersUnbound<T, S> parametersUnbound = new ParametersUnbound<T, S>(parametersExperiment, input, sharedState, this.isSuppressExceptions());
        JobStateMonitor state = new JobStateMonitor();
        JobStartStopLogger loggerJob = this.createJobLogger(parametersExperiment, monitor);
        executorService.submit(new CallableJob(this.getTask(), parametersUnbound, this.defaultInstances, state, description, loggerJob));
        monitor.add(new SubmittedJob(description, state));
    }

    private JobStartStopLogger createJobLogger(ParametersExperiment parametersExperiment, ConcurrentJobMonitor monitor) {
        return new JobStartStopLogger("Job", monitor, false, this.showOngoingJobsLessThan, ProcessorUtilities.loggerForMonitor(parametersExperiment));
    }

    private ConcurrencyPlan createConcurrencyPlan(ParametersExperiment parametersExperiment) {
        int availableProcessors = Runtime.getRuntime().availableProcessors();
        int numberCPUs = this.selectNumberCPUs(availableProcessors);
        if (parametersExperiment.isDetailedLogging()) {
            parametersExperiment.getLoggerExperiment().logFormatted("Preparing jobs to run with common initialization.%nMaximally using %d simultaneous %s (from %d available), and up to %d simultaneous %s (if available).", new Object[]{numberCPUs, LanguageUtilities.pluralizeMaybe((long)numberCPUs, (String)"CPU"), availableProcessors, this.numberGPUProcessors, LanguageUtilities.pluralizeMaybe((long)this.numberGPUProcessors, (String)"GPU")});
        }
        return ConcurrencyPlan.multipleProcessors((int)numberCPUs, (int)this.numberGPUProcessors);
    }

    private int selectNumberCPUs(int availableProcessors) {
        int numberOfProcessors = availableProcessors - this.keepProcessorsFree;
        if (this.maxNumberProcessors > 0) {
            numberOfProcessors = Math.min(numberOfProcessors, this.maxNumberProcessors);
        }
        return numberOfProcessors;
    }

    private void logWhenIrregularlyEnded(ConcurrentJobMonitor monitor, ParametersExperiment parametersExperiment, int numberInputs) {
        if (monitor.numberExecutingJobs() != 0L || monitor.numberUncompletedJobs() != 0L || monitor.numberCompletedJobs() != (long)numberInputs) {
            parametersExperiment.getLoggerExperiment().log("At least one experiment ended irregularly!");
        }
    }

    @Generated
    public int getMaxNumberProcessors() {
        return this.maxNumberProcessors;
    }

    @Generated
    public void setMaxNumberProcessors(int maxNumberProcessors) {
        this.maxNumberProcessors = maxNumberProcessors;
    }

    @Generated
    public int getShowOngoingJobsLessThan() {
        return this.showOngoingJobsLessThan;
    }

    @Generated
    public void setShowOngoingJobsLessThan(int showOngoingJobsLessThan) {
        this.showOngoingJobsLessThan = showOngoingJobsLessThan;
    }

    @Generated
    public int getKeepProcessorsFree() {
        return this.keepProcessorsFree;
    }

    @Generated
    public void setKeepProcessorsFree(int keepProcessorsFree) {
        this.keepProcessorsFree = keepProcessorsFree;
    }

    @Generated
    public int getNumberGPUProcessors() {
        return this.numberGPUProcessors;
    }

    @Generated
    public void setNumberGPUProcessors(int numberGPUProcessors) {
        this.numberGPUProcessors = numberGPUProcessors;
    }
}

