/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.experiment.bean.task;

import java.nio.file.Path;
import java.util.Optional;
import lombok.Generated;
import org.anchoranalysis.experiment.JobExecutionException;
import org.anchoranalysis.experiment.task.ParametersExperiment;
import org.anchoranalysis.io.input.InputFromManager;
import org.anchoranalysis.io.output.outputter.BindFailedException;
import org.anchoranalysis.io.output.outputter.OutputterChecked;
import org.anchoranalysis.io.output.path.prefixer.DirectoryWithPrefix;
import org.anchoranalysis.io.output.path.prefixer.NamedPath;
import org.anchoranalysis.io.output.path.prefixer.PathPrefixerException;

class TaskOutputterFactory {
    public static OutputterChecked createOutputterForTask(InputFromManager input, ParametersExperiment parameters) throws JobExecutionException {
        try {
            Optional pathForBinding = input.pathForBinding();
            if (pathForBinding.isPresent()) {
                return TaskOutputterFactory.createWithBindingPath(TaskOutputterFactory.derivePathWithDescription(input), parameters);
            }
            return parameters.getOutputter().getChecked();
        }
        catch (BindFailedException e) {
            throw new JobExecutionException(String.format("Cannot bind an outputter for the specific task with pathForBinding=%s and experimentIdentifier='%s'", TaskOutputterFactory.describeInputForBinding(input), parameters.getExperimentIdentifier()), e);
        }
    }

    private static NamedPath derivePathWithDescription(InputFromManager input) {
        return new NamedPath(input.identifier(), (Path)input.pathForBinding().get());
    }

    private static String describeInputForBinding(InputFromManager input) {
        return input.pathForBinding().map(TaskOutputterFactory::quoteString).orElse("<no binding path>");
    }

    private static String quoteString(Path path) {
        return String.format("'%s'", path.toString());
    }

    private static OutputterChecked createWithBindingPath(NamedPath path, ParametersExperiment parameters) throws BindFailedException {
        try {
            DirectoryWithPrefix prefixToAssign = parameters.getPrefixer().outFilePrefix(path, parameters.experimentIdentifierForOutputPath(), parameters.getExecutionArguments().derivePathPrefixerContext());
            return parameters.getOutputter().getChecked().changePrefix(prefixToAssign);
        }
        catch (PathPrefixerException e) {
            throw new BindFailedException((Throwable)e);
        }
    }

    @Generated
    private TaskOutputterFactory() {
    }
}

