/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.experiment.log;

import java.io.PrintWriter;
import lombok.Generated;
import org.anchoranalysis.core.functional.OptionalUtilities;
import org.anchoranalysis.core.log.MessageLogger;
import org.anchoranalysis.core.log.error.ErrorReporter;
import org.anchoranalysis.experiment.log.MessageLoggerHelper;
import org.anchoranalysis.experiment.log.StatefulMessageLogger;
import org.anchoranalysis.io.output.error.OutputWriteFailedException;
import org.anchoranalysis.io.output.outputter.OutputterChecked;

public class FailureOnlyMessageLogger
implements StatefulMessageLogger {
    private final String outputName;
    private final OutputterChecked outputter;
    private final ErrorReporter errorReporter;
    private final boolean considerWarningAsFailure;
    private StringBuilder builder;

    public void log(String message) {
        this.builder.append(message);
        this.builder.append(System.lineSeparator());
    }

    public void logFormatted(String formatString, Object ... args) {
        this.log(String.format(formatString, args));
    }

    @Override
    public void start() {
        this.builder = new StringBuilder();
    }

    @Override
    public void close(boolean successful, boolean warningOccurred) {
        if (!successful || this.considerWarningAsFailure && warningOccurred) {
            this.writeStringToFile(this.builder.toString());
        }
    }

    private void writeStringToFile(String message) {
        try {
            OptionalUtilities.ifPresent(MessageLoggerHelper.createOutput(this.outputter, this.outputName), output -> {
                output.start();
                ((PrintWriter)output.getWriter().get()).append(message);
                output.end();
            });
        }
        catch (OutputWriteFailedException e) {
            this.errorReporter.recordError(MessageLogger.class, (Throwable)e);
        }
    }

    @Generated
    public FailureOnlyMessageLogger(String outputName, OutputterChecked outputter, ErrorReporter errorReporter, boolean considerWarningAsFailure) {
        this.outputName = outputName;
        this.outputter = outputter;
        this.errorReporter = errorReporter;
        this.considerWarningAsFailure = considerWarningAsFailure;
    }
}

