/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.experiment.log;

import java.io.PrintWriter;
import java.util.Optional;
import java.util.function.Supplier;
import org.anchoranalysis.core.exception.OperationFailedException;
import org.anchoranalysis.core.functional.OptionalUtilities;
import org.anchoranalysis.core.log.MessageLogger;
import org.anchoranalysis.core.log.error.ErrorReporter;
import org.anchoranalysis.experiment.log.MessageLoggerHelper;
import org.anchoranalysis.experiment.log.StatefulMessageLogger;
import org.anchoranalysis.io.generator.text.TextFileOutput;
import org.anchoranalysis.io.output.error.OutputDirectoryAlreadyExistsException;
import org.anchoranalysis.io.output.outputter.OutputterChecked;

public class TextFileMessageLogger
implements StatefulMessageLogger {
    private final Supplier<Optional<TextFileOutput>> fileOutputSupplier;
    private final ErrorReporter errorReporter;
    private Optional<TextFileOutput> fileOutput = Optional.empty();
    private Optional<PrintWriter> printWriter = Optional.empty();
    private final Object lockWriter = new Object();

    public TextFileMessageLogger(String filePath, ErrorReporter errorReporter) {
        this.fileOutputSupplier = () -> Optional.of(new TextFileOutput(filePath));
        this.errorReporter = errorReporter;
    }

    public TextFileMessageLogger(String outputName, OutputterChecked outputter, ErrorReporter errorReporter) {
        this.fileOutputSupplier = () -> MessageLoggerHelper.createOutput(outputter, outputName);
        this.errorReporter = errorReporter;
    }

    public void logFormatted(String formatString, Object ... args) {
        this.log(String.format(formatString, args));
    }

    @Override
    public void start() throws OperationFailedException {
        try {
            this.fileOutput = this.fileOutputSupplier.get();
            this.printWriter = OptionalUtilities.map(this.fileOutput, output -> {
                output.start();
                return (PrintWriter)output.getWriter().get();
            });
        }
        catch (OutputDirectoryAlreadyExistsException e) {
            throw new OperationFailedException((Throwable)e);
        }
        catch (Exception e) {
            this.errorReporter.recordError(MessageLogger.class, (Throwable)e);
        }
    }

    public void log(String message) {
        this.printWriter.ifPresent(writer -> {
            Object object = this.lockWriter;
            synchronized (object) {
                writer.print(message);
                writer.println();
                writer.flush();
            }
        });
    }

    @Override
    public void close(boolean successful, boolean warningOccurred) {
        this.fileOutput.ifPresent(TextFileOutput::end);
    }
}

