/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.experiment.task;

import org.anchoranalysis.core.log.MessageLogger;
import org.anchoranalysis.core.log.error.ErrorReporter;
import org.anchoranalysis.core.log.error.ErrorReporterIntoLog;

public class ErrorReporterForTask
implements ErrorReporter {
    private ErrorReporter delegate;

    public ErrorReporterForTask(MessageLogger logger) {
        this.delegate = new ErrorReporterIntoLog(logger);
    }

    public void recordError(Class<?> classOriginating, Throwable exc) {
        if (exc instanceof OutOfMemoryError) {
            this.delegate.recordError(classOriginating, "There is insufficient memory available for this task. Consider allocating more memory to the Java Virtual Machine with the -XmX argument.");
        } else {
            this.delegate.recordError(classOriginating, exc);
        }
    }

    public void recordError(Class<?> classOriginating, String message) {
        this.delegate.recordError(classOriginating, message);
    }

    public void recordError(Class<?> classOriginating, String message, Throwable exc) {
        this.delegate.recordError(classOriginating, message, exc);
    }

    public void recordWarning(String message) {
        this.delegate.recordWarning(message);
    }

    public boolean hasWarningOccurred() {
        return this.delegate.hasWarningOccurred();
    }
}

