/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.experiment.task;

import java.util.Optional;
import lombok.Generated;
import org.anchoranalysis.core.time.ExecutionTimeRecorder;
import org.anchoranalysis.core.time.RecordedExecutionTimes;
import org.anchoranalysis.experiment.arguments.ExecutionArguments;
import org.anchoranalysis.experiment.bean.log.LoggingDestination;
import org.anchoranalysis.experiment.io.InitializationContext;
import org.anchoranalysis.experiment.log.StatefulMessageLogger;
import org.anchoranalysis.experiment.task.ExperimentFeedbackContext;
import org.anchoranalysis.experiment.task.InputOutputContextStateful;
import org.anchoranalysis.io.output.bean.path.prefixer.PathPrefixer;
import org.anchoranalysis.io.output.outputter.Outputter;
import org.anchoranalysis.io.output.outputter.OutputterChecked;

public class ParametersExperiment {
    private ExecutionArguments executionArguments;
    private final String experimentIdentifier;
    private final InputOutputContextStateful context;
    private final PathPrefixer prefixer;
    private LoggingDestination loggerTaskCreator;
    private final boolean detailedLogging;
    private ExecutionTimeRecorder executionTimeRecorder;

    public ParametersExperiment(ExecutionArguments executionArguments, String experimentIdentifier, OutputterChecked outputter, PathPrefixer prefixer, ExperimentFeedbackContext feedbackContext) {
        this.executionTimeRecorder = feedbackContext.getExecutionTimeRecorder();
        this.executionArguments = executionArguments;
        this.context = feedbackContext.inputOutput(executionArguments, outputter);
        this.experimentIdentifier = experimentIdentifier;
        this.detailedLogging = feedbackContext.isDetailedLogging();
        this.prefixer = prefixer;
    }

    public Optional<String> experimentIdentifierForOutputPath() {
        if (!this.executionArguments.output().getPrefixer().isOmitExperimentIdentifier()) {
            return Optional.of(this.experimentIdentifier);
        }
        return Optional.empty();
    }

    public Outputter getOutputter() {
        return this.context.getOutputter();
    }

    public StatefulMessageLogger getLoggerExperiment() {
        return this.context.getMessageLogger();
    }

    public ExecutionArguments getExecutionArguments() {
        return this.context.getExecutionArguments();
    }

    public InitializationContext deriveInitializationContext() {
        return new InitializationContext(this.context, this.context.getExecutionArguments().task().getSize());
    }

    public RecordedExecutionTimes executionTimeStatistics() {
        return this.executionTimeRecorder.recordedTimes();
    }

    @Generated
    public String getExperimentIdentifier() {
        return this.experimentIdentifier;
    }

    @Generated
    public InputOutputContextStateful getContext() {
        return this.context;
    }

    @Generated
    public PathPrefixer getPrefixer() {
        return this.prefixer;
    }

    @Generated
    public LoggingDestination getLoggerTaskCreator() {
        return this.loggerTaskCreator;
    }

    @Generated
    public void setLoggerTaskCreator(LoggingDestination loggerTaskCreator) {
        this.loggerTaskCreator = loggerTaskCreator;
    }

    @Generated
    public boolean isDetailedLogging() {
        return this.detailedLogging;
    }

    @Generated
    public ExecutionTimeRecorder getExecutionTimeRecorder() {
        return this.executionTimeRecorder;
    }
}

