/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.experiment.task;

import lombok.Generated;
import org.anchoranalysis.math.arithmetic.RunningSum;

public class TaskStatistics {
    private final long numberTotalScheduledJobs;
    private final RunningSum success;
    private final RunningSum failed;

    public long numberNotCompleted() {
        long numberNotCompleted = this.numberTotalScheduledJobs - this.numberCompletedSuccess() - this.numberCompletedFailed();
        assert (numberNotCompleted >= 0L);
        return numberNotCompleted;
    }

    public RunningSum executionTimeTotal() {
        RunningSum total = this.success.duplicate();
        total.add(this.failed);
        return total;
    }

    public double meanExecutionTimeSuccess() {
        return this.success.mean();
    }

    public double meanExecutionTimeFailed() {
        return this.failed.mean();
    }

    public boolean allSuccessful() {
        return this.numberCompletedSuccess() == this.numberTotalScheduledJobs;
    }

    public long numberCompletedSuccess() {
        return this.success.getCount();
    }

    public long numberCompletedFailed() {
        return this.failed.getCount();
    }

    public long numberCompletedTotal() {
        return this.numberCompletedSuccess() + this.numberCompletedFailed();
    }

    @Generated
    public TaskStatistics(long numberTotalScheduledJobs, RunningSum success, RunningSum failed) {
        this.numberTotalScheduledJobs = numberTotalScheduledJobs;
        this.success = success;
        this.failed = failed;
    }

    @Generated
    public long numberTotalScheduledJobs() {
        return this.numberTotalScheduledJobs;
    }
}

