/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.experiment.task.processor;

import com.google.common.base.Preconditions;
import java.util.Optional;
import java.util.concurrent.Callable;
import lombok.Generated;
import org.anchoranalysis.bean.BeanInstanceMap;
import org.anchoranalysis.experiment.JobExecutionException;
import org.anchoranalysis.experiment.bean.task.Task;
import org.anchoranalysis.experiment.task.ErrorReporterForTask;
import org.anchoranalysis.experiment.task.ParametersUnbound;
import org.anchoranalysis.experiment.task.processor.JobDescription;
import org.anchoranalysis.experiment.task.processor.JobStartStopLogger;
import org.anchoranalysis.experiment.task.processor.JobStateMonitor;
import org.anchoranalysis.io.input.InputFromManager;

public class CallableJob<T extends InputFromManager, S>
implements Callable<Optional<JobExecutionException>> {
    private final Task<T, S> task;
    private final ParametersUnbound<T, S> parametersUnbound;
    private final BeanInstanceMap defaultInstances;
    private final JobStateMonitor stateMonitor;
    private final JobDescription jobDescription;
    private final JobStartStopLogger logger;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Optional<JobExecutionException> call() {
        Optional<JobExecutionException> optional;
        try {
            Task taskDuplicated = (Task)((Object)this.task.duplicateBean());
            taskDuplicated.checkMisconfigured(this.defaultInstances);
            this.stateMonitor.markAsExecuting();
            this.logger.logStart(this.jobDescription);
            boolean success = taskDuplicated.executeJob(this.parametersUnbound);
            this.closeJobStateAndLog(success);
            optional = Optional.empty();
            Preconditions.checkArgument((!this.stateMonitor.isExecuting() ? 1 : 0) != 0);
        }
        catch (Throwable e) {
            Optional<JobExecutionException> optional2;
            try {
                ErrorReporterForTask errorReporter = new ErrorReporterForTask(this.parametersUnbound.getParametersExperiment().getLoggerExperiment());
                errorReporter.recordError(CallableJob.class, e);
                this.closeJobStateAndLog(false);
                optional2 = Optional.of(new JobExecutionException(e));
                Preconditions.checkArgument((!this.stateMonitor.isExecuting() ? 1 : 0) != 0);
            }
            catch (Throwable throwable) {
                Preconditions.checkArgument((!this.stateMonitor.isExecuting() ? 1 : 0) != 0);
                throw throwable;
            }
            return optional2;
        }
        return optional;
    }

    private void closeJobStateAndLog(boolean success) {
        this.stateMonitor.markAsCompleted(success);
        this.logger.logEnd(this.jobDescription, this.stateMonitor);
    }

    @Generated
    public CallableJob(Task<T, S> task, ParametersUnbound<T, S> parametersUnbound, BeanInstanceMap defaultInstances, JobStateMonitor stateMonitor, JobDescription jobDescription, JobStartStopLogger logger) {
        this.task = task;
        this.parametersUnbound = parametersUnbound;
        this.defaultInstances = defaultInstances;
        this.stateMonitor = stateMonitor;
        this.jobDescription = jobDescription;
        this.logger = logger;
    }
}

