/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.experiment.task.processor;

import org.anchoranalysis.core.exception.OperationFailedRuntimeException;
import org.apache.commons.lang.time.StopWatch;

public class JobStateMonitor {
    private StopWatch stopWatch = new StopWatch();
    private State state = State.UNSTARTED;

    public boolean isUnstarted() {
        return this.state == State.UNSTARTED;
    }

    public boolean isExecuting() {
        return this.state == State.EXECUTING;
    }

    public boolean isCompleted() {
        return this.isCompletedSuccessfully() || this.isCompletedFailure();
    }

    public boolean isCompletedSuccessfully() {
        return this.state == State.COMPLETED_SUCCESS;
    }

    public boolean isCompletedFailure() {
        return this.state == State.COMPLETED_FAILURE;
    }

    public void markAsExecuting() {
        if (this.state != State.UNSTARTED) {
            throw new OperationFailedRuntimeException("The job must be unstarted to call this method.");
        }
        this.state = State.EXECUTING;
        this.stopWatch.start();
    }

    public void markAsCompleted(boolean successful) {
        if (this.state != State.EXECUTING) {
            throw new OperationFailedRuntimeException("The job must be executing to call this method.");
        }
        this.state = successful ? State.COMPLETED_SUCCESS : State.COMPLETED_FAILURE;
        this.stopWatch.stop();
    }

    public int getExecutionDuration() {
        if (this.state == State.UNSTARTED || this.state == State.EXECUTING) {
            throw new OperationFailedRuntimeException("The job must be completed to call this method.");
        }
        return (int)this.stopWatch.getTime();
    }

    private static enum State {
        UNSTARTED,
        EXECUTING,
        COMPLETED_SUCCESS,
        COMPLETED_FAILURE;

    }
}

