/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.experiment.time;

import lombok.Generated;
import org.anchoranalysis.core.time.RecordedExecutionTimes;
import org.anchoranalysis.core.value.LanguageUtilities;
import org.anchoranalysis.core.value.StringUtilities;
import org.apache.commons.lang3.StringUtils;

class DescribeOperations {
    private static final int WIDTH_IDENTIFIER = 51;
    private static final int WIDTH_EXECUTION_TIME = 13;

    public static String allOperations(RecordedExecutionTimes operationStatistics) {
        if (!operationStatistics.isEmpty()) {
            StringBuilder builder = new StringBuilder();
            operationStatistics.forEach(recorded -> builder.append(DescribeOperations.individual(recorded)));
            return builder.toString();
        }
        return "";
    }

    public static String individual(RecordedExecutionTimes.RecordedOperation operation) {
        String prefix = StringUtils.repeat((String)"..", (int)operation.getNumberParentOperations());
        String paddedIdentifier = StringUtilities.rightPad((String)(prefix + operation.getOperationIdentifier()), (int)51);
        String suffix = String.format("across %d %s", operation.getCount(), LanguageUtilities.pluralizeMaybe((long)operation.getCount(), (String)"instance"));
        return String.format("%s\t = %s%s\t%s%n", paddedIdentifier, DescribeOperations.describeTime(operation.meanExecutionTimeSeconds()), DescribeOperations.describeTime(operation.sumExecutionTimeSeconds()), suffix);
    }

    private static String describeTime(double executionTime) {
        return StringUtilities.leftPad((String)String.format("%.3f s", executionTime), (int)13);
    }

    @Generated
    private DescribeOperations() {
    }
}

