/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.experiment.time;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.anchoranalysis.experiment.time.RunningSumParented;
import org.anchoranalysis.math.arithmetic.RunningSum;

class RunningSumMap<T> {
    private Map<T, RunningSumParented> map = new LinkedHashMap<T, RunningSumParented>();

    RunningSumMap() {
    }

    public boolean containsKey(T key) {
        return this.map.containsKey(key);
    }

    public RunningSum get(T key, int numberParentOperations) {
        return this.map.computeIfAbsent(key, value -> new RunningSumParented(numberParentOperations)).getRunningSum();
    }

    public void reset() {
        this.map.forEach((key, value) -> value.getRunningSum().reset());
    }

    public Map<T, Double> meanAndReset() {
        return this.map.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> ((RunningSumParented)entry.getValue()).getRunningSum().meanAndReset()));
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    public Set<Map.Entry<T, RunningSumParented>> entrySet() {
        return this.map.entrySet();
    }
}

