/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.experiment.time;

import java.util.Map;
import java.util.stream.Stream;
import org.anchoranalysis.core.time.ExecutionTimeRecorder;
import org.anchoranalysis.core.time.RecordedExecutionTimes;
import org.anchoranalysis.experiment.time.RecordedOperationHelper;
import org.anchoranalysis.experiment.time.RunningSumMap;
import org.anchoranalysis.experiment.time.RunningSumParented;

class RunningSumRecorder
extends ExecutionTimeRecorder {
    private RunningSumMap<String> map = new RunningSumMap();
    private ThreadLocal<Integer> threadLocal = ThreadLocal.withInitial(() -> 0);

    RunningSumRecorder() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void recordExecutionTime(String operationIdentifier, long millis) {
        RunningSumMap<String> runningSumMap = this.map;
        synchronized (runningSumMap) {
            int countOngoing = this.threadLocal.get();
            if (countOngoing <= 1) {
                this.threadLocal.remove();
            } else {
                this.threadLocal.set(countOngoing - 1);
            }
            this.map.get(operationIdentifier, countOngoing - 1).increment((double)millis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long measureTime(boolean start, String ... operationIdentifiers) {
        if (start) {
            RunningSumMap<String> runningSumMap = this.map;
            synchronized (runningSumMap) {
                int countOngoing = this.threadLocal.get();
                try {
                    for (String identifier : operationIdentifiers) {
                        this.map.get(identifier, countOngoing);
                    }
                }
                finally {
                    this.threadLocal.set(countOngoing + 1);
                }
            }
        }
        return System.currentTimeMillis();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isOperationAlreadyRecorded(String operationIdentifier) {
        RunningSumMap<String> runningSumMap = this.map;
        synchronized (runningSumMap) {
            return this.map.containsKey(operationIdentifier) && this.map.get(operationIdentifier, 0).getCount() > 0L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, Double> meanAndReset() {
        RunningSumMap<String> runningSumMap = this.map;
        synchronized (runningSumMap) {
            return this.map.meanAndReset();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEmpty() {
        RunningSumMap<String> runningSumMap = this.map;
        synchronized (runningSumMap) {
            return this.map.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RecordedExecutionTimes recordedTimes() {
        RunningSumMap<String> runningSumMap = this.map;
        synchronized (runningSumMap) {
            Stream<Map.Entry> entriesFiltered = this.map.entrySet().stream().filter(entry -> ((RunningSumParented)entry.getValue()).getRunningSum().getCount() > 0L);
            return new RecordedExecutionTimes(entriesFiltered.map(RunningSumRecorder::recordedOperationFromEntry));
        }
    }

    private static RecordedExecutionTimes.RecordedOperation recordedOperationFromEntry(Map.Entry<String, RunningSumParented> entry) {
        return RecordedOperationHelper.create(entry.getKey(), entry.getValue().getRunningSum(), entry.getValue().getNumberParentOperations());
    }
}

