/*-
 * #%L
 * anchor-feature-io
 * %%
 * Copyright (C) 2010 - 2020 Owen Feehan, ETH Zurich, University of Zurich, Hoffmann-La Roche
 * %%
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 * #L%
 */

package org.anchoranalysis.feature.io.csv.metadata;

import lombok.AllArgsConstructor;
import lombok.Getter;
import org.apache.commons.lang3.ArrayUtils;

/**
 * Headers in a CSV file for the non-results (i.e. labels) part of a feature-row
 *
 * @author Owen Feehan
 */
@AllArgsConstructor
public class LabelHeaders {

    /**
     * Headers describing the non-feature columns outputted in the CSV related to identifying a row
     * (but not its group)
     */
    private String[] nonGroupHeaders;

    /**
     * Headers describing the non-feature columns outputted in the CSV related to identifying the
     * group of a row
     */
    @Getter private String[] groupHeaders;

    /**
     * The non-group and group headers combined (in this order respectively)
     *
     * @return the combined headers in a newly created array
     */
    public String[] allHeaders() {
        return ArrayUtils.addAll(nonGroupHeaders, groupHeaders);
    }

    /**
     * Creates with only non-group headers
     *
     * @param nonGroupHeaders headers describing the non-feature columns outputted in the CSV
     *     related to identifying a row
     */
    public LabelHeaders(String[] nonGroupHeaders) {
        this(nonGroupHeaders, new String[] {});
    }
}
