/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.feature.io.csv;

import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import org.anchoranalysis.core.value.TypedValue;
import org.anchoranalysis.feature.io.csv.metadata.FeatureCSVMetadata;
import org.anchoranalysis.feature.io.csv.metadata.RowLabels;
import org.anchoranalysis.feature.io.results.LabelledResultsVector;
import org.anchoranalysis.feature.results.ResultsVector;
import org.anchoranalysis.io.generator.tabular.CSVWriter;
import org.anchoranalysis.io.output.error.OutputWriteFailedException;
import org.anchoranalysis.io.output.outputter.Outputter;
import org.anchoranalysis.io.output.outputter.OutputterChecked;

public class FeatureCSVWriter {
    public static final int NUMBER_DECIMAL_PLACES = 10;
    private final CSVWriter writer;
    private final int numberDecimalPlaces;

    public FeatureCSVWriter(CSVWriter writer, boolean visuallyShortenedDecimals) {
        this.writer = writer;
        this.numberDecimalPlaces = visuallyShortenedDecimals ? -1 : 10;
    }

    public static Optional<FeatureCSVWriter> create(FeatureCSVMetadata metadata, Outputter outputter, boolean visuallyShortenedDecimals) throws OutputWriteFailedException {
        if (!outputter.outputsEnabled().isOutputEnabled(metadata.getOutputName())) {
            return Optional.of(new FeatureCSVWriter(null, visuallyShortenedDecimals));
        }
        Optional writerOptional = CSVWriter.createFromOutputter((String)metadata.getOutputName(), (OutputterChecked)outputter.getChecked());
        return writerOptional.map(writer -> {
            writer.writeHeaders(metadata.getHeaders());
            return new FeatureCSVWriter((CSVWriter)writer, visuallyShortenedDecimals);
        });
    }

    public void addRow(LabelledResultsVector results) {
        if (this.writer == null) {
            return;
        }
        this.addRow(this.buildCSVRow(results.getLabels(), results.getResults()));
    }

    public void addRow(List<TypedValue> values) {
        if (this.writer == null) {
            return;
        }
        this.writer.writeRow(values);
    }

    public void close() {
        if (this.writer == null) {
            return;
        }
        this.writer.close();
    }

    private List<TypedValue> buildCSVRow(RowLabels identifier, ResultsVector resultsFromFeatures) {
        LinkedList<TypedValue> csvRow = new LinkedList<TypedValue>();
        identifier.addToRow(csvRow);
        resultsFromFeatures.addTypedValuesTo(csvRow, this.numberDecimalPlaces);
        return csvRow;
    }
}

