/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.feature.io.csv.metadata;

import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.anchoranalysis.core.value.TypedValue;
import org.anchoranalysis.feature.io.name.MultiName;

public class RowLabels {
    private final Optional<String[]> identifier;
    private final Optional<MultiName> group;

    public RowLabels(String identifier) {
        this(Optional.of(new String[]{identifier}), Optional.empty());
    }

    public void addToRow(List<TypedValue> csvRow) {
        this.identifier.ifPresent(array -> RowLabels.addStringArrayToRow(array, csvRow));
        this.group.ifPresent(multiName -> RowLabels.addStringIterableToRow(multiName, csvRow));
    }

    private static void addStringArrayToRow(String[] array, List<TypedValue> csvRow) {
        Arrays.stream(array).forEach(str -> csvRow.add(new TypedValue(str)));
    }

    private static void addStringIterableToRow(Iterable<String> iterable, List<TypedValue> csvRow) {
        for (String string : iterable) {
            csvRow.add(new TypedValue(string));
        }
    }

    public RowLabels(Optional<String[]> identifier, Optional<MultiName> group) {
        this.identifier = identifier;
        this.group = group;
    }

    public Optional<MultiName> getGroup() {
        return this.group;
    }
}

