/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.feature.io.csv.results;

import java.util.Iterator;
import java.util.List;
import org.anchoranalysis.feature.io.results.LabelledResultsVector;
import org.anchoranalysis.feature.name.FeatureNameList;
import org.anchoranalysis.feature.results.ResultsVector;

class IndexRemover {
    public static void removeResultsAtIndices(List<LabelledResultsVector> results, List<Integer> indicesToRemove) {
        if (indicesToRemove.isEmpty()) {
            // empty if block
        }
        for (int i = 0; i < results.size(); ++i) {
            LabelledResultsVector labelledResult = results.get(i);
            ResultsVector replacement = IndexRemover.removeIndicesFromResults(labelledResult.getResults(), indicesToRemove);
            results.set(i, new LabelledResultsVector(labelledResult.getLabels(), replacement));
        }
    }

    public static FeatureNameList removeHeadersAtIndices(FeatureNameList featureNames, List<Integer> indicesToRemove) {
        if (indicesToRemove.isEmpty()) {
            return featureNames;
        }
        FeatureNameList namesKept = new FeatureNameList();
        Iterator<Integer> iteratorOmitIndices = indicesToRemove.iterator();
        int omitNext = IndexRemover.nextIndexToOmit(iteratorOmitIndices);
        for (int i = 0; i < featureNames.size(); ++i) {
            if (i == omitNext) {
                omitNext = IndexRemover.nextIndexToOmit(iteratorOmitIndices);
                continue;
            }
            namesKept.add(featureNames.get(i));
        }
        return namesKept;
    }

    private static int nextIndexToOmit(Iterator<Integer> iteratorOmitIndices) {
        if (iteratorOmitIndices.hasNext()) {
            return iteratorOmitIndices.next();
        }
        return -1;
    }

    private static ResultsVector removeIndicesFromResults(ResultsVector results, List<Integer> indicesToRemove) {
        ResultsVector out = new ResultsVector(results.size() - indicesToRemove.size());
        Iterator<Integer> iteratorOmitIndices = indicesToRemove.iterator();
        int omitNext = IndexRemover.nextIndexToOmit(iteratorOmitIndices);
        int outIndex = 0;
        for (int i = 0; i < results.size(); ++i) {
            if (i == omitNext) {
                omitNext = IndexRemover.nextIndexToOmit(iteratorOmitIndices);
                continue;
            }
            out.set(outIndex++, results.get(i));
        }
        return out;
    }

    private IndexRemover() {
    }
}

