/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.feature.io.name;

import java.util.Arrays;
import java.util.Iterator;
import java.util.Optional;
import org.anchoranalysis.feature.io.name.MultiName;

public class CombinedName
implements MultiName {
    private static final String SEPARATOR = "/";
    private String key;
    private String remainder;
    private String allTogether;

    public CombinedName(String key, String remainder) {
        this.key = key;
        this.remainder = remainder;
        this.allTogether = String.join((CharSequence)SEPARATOR, key, remainder);
    }

    public int hashCode() {
        return this.allTogether.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof CombinedName) {
            CombinedName objCast = (CombinedName)obj;
            return this.allTogether.equals(objCast.allTogether);
        }
        return false;
    }

    @Override
    public Optional<String> firstPart() {
        return Optional.of(this.key);
    }

    @Override
    public Iterator<String> iterator() {
        return Arrays.asList(this.key, this.remainder).iterator();
    }

    @Override
    public String secondPart() {
        return this.remainder;
    }

    @Override
    public String toString() {
        return this.allTogether;
    }

    @Override
    public int compareTo(MultiName other) {
        if (other instanceof CombinedName) {
            CombinedName otherCast = (CombinedName)other;
            int compareResult = this.key.compareTo(otherCast.key);
            if (compareResult != 0) {
                return compareResult;
            }
            return this.remainder.compareTo(otherCast.remainder);
        }
        return 1;
    }
}

