/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.feature.io.results.group;

import com.google.common.collect.Comparators;
import java.util.Comparator;
import java.util.Optional;
import org.anchoranalysis.core.collection.MapCreate;
import org.anchoranalysis.core.functional.checked.CheckedBiConsumer;
import org.anchoranalysis.feature.io.name.MultiName;
import org.anchoranalysis.feature.io.results.LabelledResultsVector;
import org.anchoranalysis.feature.results.ResultsVectorList;

class ResultsMap {
    private MapCreate<Optional<MultiName>, ResultsVectorList> map = new MapCreate(ResultsVectorList::new, Comparators.emptiesFirst(Comparator.naturalOrder()));

    ResultsMap() {
    }

    public synchronized void addResultsFor(LabelledResultsVector results) {
        ((ResultsVectorList)this.map.computeIfAbsent(results.getLabels().getGroup())).add(results.getResults());
    }

    public <E extends Exception> void iterateResults(CheckedBiConsumer<Optional<MultiName>, ResultsVectorList, E> operation) throws E {
        this.map.iterateEntries(operation);
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }
}

