/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.feature.io.csv.results;

import java.util.Optional;
import java.util.function.Consumer;
import lombok.Generated;
import org.anchoranalysis.feature.io.csv.FeatureCSVWriter;
import org.anchoranalysis.feature.io.csv.metadata.FeatureCSVMetadata;
import org.anchoranalysis.feature.io.csv.metadata.FeatureCSVMetadataForOutput;
import org.anchoranalysis.feature.io.csv.results.FeatureCSVWriterFactory;
import org.anchoranalysis.feature.io.results.LabelledResultsVector;
import org.anchoranalysis.io.output.error.OutputWriteFailedException;

public abstract class LabelledResultsCSVWriter {
    protected final FeatureCSVMetadataForOutput outputMetadata;
    private final FeatureCSVWriterFactory writerCreator;
    private final Optional<Consumer<LabelledResultsVector>> consumeAfterAdding;

    public abstract void start() throws OutputWriteFailedException;

    public abstract void add(LabelledResultsVector var1);

    public abstract void end() throws OutputWriteFailedException;

    protected Optional<FeatureCSVWriter> createWriter(FeatureCSVMetadata csvMetadata) throws OutputWriteFailedException {
        return this.writerCreator.create(csvMetadata);
    }

    protected void maybeConsumeResults(LabelledResultsVector results) {
        this.consumeAfterAdding.ifPresent(consumer -> consumer.accept(results));
    }

    @Generated
    protected LabelledResultsCSVWriter(FeatureCSVMetadataForOutput outputMetadata, FeatureCSVWriterFactory writerCreator, Optional<Consumer<LabelledResultsVector>> consumeAfterAdding) {
        this.outputMetadata = outputMetadata;
        this.writerCreator = writerCreator;
        this.consumeAfterAdding = consumeAfterAdding;
    }
}

